/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class BasicAccessTokenValidator {
    public static final ErrorResponse MISSING_BEARER_TOKEN;
    public static final ErrorResponse INVALID_BEARER_TOKEN;
    public static final ErrorResponse WEB_API_DISABLED;
    private final BearerAccessToken accessToken;

    public BasicAccessTokenValidator(BearerAccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public BearerAccessToken getAccessToken() {
        return this.accessToken;
    }

    public void validateBearerAccessToken(String authzHeader) throws WebApplicationException {
        BearerAccessToken receivedToken;
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        try {
            receivedToken = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        if (this.accessToken == null) {
            throw WEB_API_DISABLED.toWebAppException();
        }
        if (!receivedToken.equals((Object)this.accessToken)) {
            throw INVALID_BEARER_TOKEN.toWebAppException();
        }
    }

    public boolean validateBearerAccessToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        BearerAccessToken receivedToken;
        String authzHeader = servletRequest.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            MISSING_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        try {
            receivedToken = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            MISSING_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        if (this.accessToken == null) {
            WEB_API_DISABLED.apply(servletResponse);
            return false;
        }
        if (!receivedToken.equals((Object)this.accessToken)) {
            INVALID_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        return true;
    }

    static {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"missing_token");
        o.put((Object)"error_description", (Object)"Unauthorized: Missing Bearer access token");
        MISSING_BEARER_TOKEN = new ErrorResponse(BearerTokenError.MISSING_TOKEN.getHTTPStatusCode(), BearerTokenError.MISSING_TOKEN.toWWWAuthenticateHeader(), o.toJSONString());
        o = new JSONObject();
        o.put((Object)"error", (Object)BearerTokenError.INVALID_TOKEN.getCode());
        o.put((Object)"error_description", (Object)"Unauthorized: Invalid Bearer access token");
        INVALID_BEARER_TOKEN = new ErrorResponse(BearerTokenError.INVALID_TOKEN.getHTTPStatusCode(), BearerTokenError.INVALID_TOKEN.toWWWAuthenticateHeader(), o.toJSONString());
        o = new JSONObject();
        o.put((Object)"error", (Object)"web_api_disabled");
        o.put((Object)"error_description", (Object)"Forbidden: Web API disabled");
        WEB_API_DISABLED = new ErrorResponse(403, null, o.toJSONString());
    }

    public static class ErrorResponse {
        private final int statusCode;
        private final String wwwAuthHeader;
        private final String body;

        public ErrorResponse(int statusCode, String wwwAuthHeader, String body) {
            this.statusCode = statusCode;
            this.wwwAuthHeader = wwwAuthHeader;
            this.body = body;
        }

        public WebApplicationException toWebAppException() {
            Response.ResponseBuilder builder = Response.status((int)this.statusCode);
            if (this.wwwAuthHeader != null) {
                builder.header("WWW-Authenticate", (Object)this.wwwAuthHeader);
            }
            return new WebApplicationException(builder.entity((Object)this.body).type("application/json").build());
        }

        public void apply(HttpServletResponse servletResponse) throws IOException {
            servletResponse.setStatus(this.statusCode);
            if (this.wwwAuthHeader != null) {
                servletResponse.setHeader("WWW-Authenticate", this.wwwAuthHeader);
            }
            if (this.body != null) {
                servletResponse.setContentType("application/json");
                servletResponse.getWriter().print(this.body);
            }
        }
    }
}

