/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.common.config.ServerSelectionAlgorithm;
import com.nimbusds.common.ldap.LDAPConnectionSecurity;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LDAPServerDetails
implements LoggableConfiguration {
    public final LDAPURL[] url;
    public final ServerSelectionAlgorithm selectionAlgorithm;
    public static final ServerSelectionAlgorithm DEFAULT_SELECTION_ALGORITHM = ServerSelectionAlgorithm.FAILOVER;
    public final LDAPConnectionSecurity security;
    public static final LDAPConnectionSecurity DEFAULT_SECURITY = LDAPConnectionSecurity.STARTTLS;
    public final int connectTimeout;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public final boolean trustSelfSignedCerts;
    public static final boolean DEFAULT_SELF_SIGNED_CERTS_TRUST = false;

    public LDAPServerDetails(LDAPURL url, LDAPConnectionSecurity security, int connectTimeout, boolean trustSelfSignedCerts) {
        if (url == null) {
            throw new IllegalArgumentException("The LDAP server URL must not be null");
        }
        this.url = new LDAPURL[1];
        this.url[0] = url;
        this.selectionAlgorithm = null;
        if (security == null) {
            throw new IllegalArgumentException("The LDAP connection security must not be null");
        }
        this.security = security;
        this.connectTimeout = connectTimeout;
        this.trustSelfSignedCerts = trustSelfSignedCerts;
    }

    public LDAPServerDetails(LDAPURL[] url, ServerSelectionAlgorithm selectionAlgorithm, LDAPConnectionSecurity security, int connectTimeout, boolean trustSelfSignedCerts) {
        if (url == null) {
            throw new IllegalArgumentException("The LDAP server URL must not be null");
        }
        if (url.length == 0) {
            throw new IllegalArgumentException("The LDAP server URL array must contain at least one entry");
        }
        this.url = url;
        if (url.length > 1 && selectionAlgorithm == null) {
            throw new IllegalArgumentException("An LDAP server selection algorithm must be specified");
        }
        this.selectionAlgorithm = selectionAlgorithm;
        if (security == null) {
            throw new IllegalArgumentException("The LDAP connection security must not be null");
        }
        this.security = security;
        this.connectTimeout = connectTimeout;
        this.trustSelfSignedCerts = trustSelfSignedCerts;
    }

    public LDAPServerDetails(String prefix, Properties props) throws PropertyParseException {
        this(prefix, props, true);
    }

    public LDAPServerDetails(String prefix, Properties props, boolean requireURL) throws PropertyParseException {
        PropertyRetriever pr = new PropertyRetriever(props);
        String urlsString = pr.getOptString(prefix + "url", null);
        if (urlsString != null && !urlsString.trim().isEmpty()) {
            String[] tokens = urlsString.split("\\s+");
            this.url = new LDAPURL[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                try {
                    this.url[i] = new LDAPURL(tokens[i]);
                }
                catch (LDAPException e) {
                    throw new PropertyParseException("Invalid LDAP URL", prefix + "url", tokens[i]);
                }
                if (this.url[i].getHost() != null) continue;
                throw new PropertyParseException("Missing host in LDAP URL", prefix + "url", tokens[i]);
            }
        } else {
            if (requireURL) {
                throw new PropertyParseException("Missing LDAP URL", prefix + "url");
            }
            this.url = null;
        }
        this.selectionAlgorithm = this.url != null && this.url.length > 1 ? (ServerSelectionAlgorithm)pr.getOptEnum(prefix + "selectionAlgorithm", ServerSelectionAlgorithm.class, (Enum)DEFAULT_SELECTION_ALGORITHM) : null;
        this.security = (LDAPConnectionSecurity)pr.getOptEnum(prefix + "security", LDAPConnectionSecurity.class, (Enum)DEFAULT_SECURITY);
        this.connectTimeout = pr.getOptInt(prefix + "connectTimeout", 0);
        this.trustSelfSignedCerts = pr.getOptBoolean(prefix + "trustSelfSignedCerts", false);
    }

    @Override
    public void log() {
        Logger log = LogManager.getLogger((String)"MAIN");
        if (this.url == null) {
            log.info("LDAP server URL: not specified");
            return;
        }
        for (int i = 0; i < this.url.length; ++i) {
            log.info("LDAP server [{}]: {}:{} (transport security {})", new Object[]{i, this.url[i].getHost(), this.url[i].getPort(), this.security});
        }
        if (this.security == LDAPConnectionSecurity.NONE) {
            log.warn("LDAP server connection not protected (security=NONE), consider using STARTTLS or SSL");
        }
        if (this.url.length > 1) {
            log.info("LDAP server selection algorithm: {}", new Object[]{this.selectionAlgorithm});
        }
        if (this.connectTimeout > 0) {
            log.info("LDAP server connect timeout: {} ms", new Object[]{this.connectTimeout});
        } else {
            log.info("LDAP server connect timeout: Determined by LDAP client library");
        }
        log.info("Self-signed LDAP server certificates are trusted: {}", new Object[]{this.trustSelfSignedCerts});
    }
}

