/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.ldap.LDAPControlResultFormatter;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.schema.AttributeSyntaxDefinition;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.AttributeUsage;
import com.unboundid.ldap.sdk.schema.MatchingRuleDefinition;
import com.unboundid.ldap.sdk.schema.MatchingRuleUseDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.util.Base64;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONResultFormatter {
    public static Map<String, Object> formatEntry(Entry entry, Set<String> binary, boolean omitDN, boolean normalize) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        if (!omitDN) {
            jsonObject.put("DN", entry.getDN());
        }
        Collection attributes = entry.getAttributes();
        for (Attribute a : attributes) {
            LinkedList<String> values = new LinkedList<String>();
            if (binary.contains(a.getName().toLowerCase())) {
                for (byte[] binVal : a.getValueByteArrays()) {
                    values.add(Base64.encode((byte[])binVal));
                }
            } else {
                Collections.addAll(values, a.getValues());
            }
            String name = a.getBaseName();
            if (normalize) {
                name = name.toLowerCase();
            }
            jsonObject.put(name, values);
        }
        return jsonObject;
    }

    public static Map<String, Object> formatEntry(Entry entry, Set<String> binary, boolean normalize) {
        return JSONResultFormatter.formatEntry(entry, binary, false, normalize);
    }

    public static Map<String, Object> formatSearchResult(SearchResult sr, Set<String> binary, boolean normalize) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        LinkedList<Map<String, Object>> matches = new LinkedList<Map<String, Object>>();
        for (SearchResultEntry entry : sr.getSearchEntries()) {
            matches.add(JSONResultFormatter.formatEntry((Entry)entry, binary, normalize));
        }
        jsonObject.put("matches", matches);
        LinkedList referrals = new LinkedList();
        for (SearchResultReference ref : sr.getSearchReferences()) {
            Collections.addAll(referrals, ref.getReferralURLs());
        }
        jsonObject.put("referrals", referrals);
        LDAPControlResultFormatter.appendSearchControlResults(jsonObject, sr);
        return jsonObject;
    }

    public static Map<String, Object> formatObjectClass(ObjectClassDefinition def) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        String oid = def.getOID();
        jsonObject.put("OID", oid);
        List<String> names = Arrays.asList(def.getNames());
        jsonObject.put("names", names);
        String description = def.getDescription();
        jsonObject.put("description", description);
        boolean obsolete = def.isObsolete();
        jsonObject.put("obsolete", obsolete);
        ObjectClassType type = def.getObjectClassType();
        if (type != null) {
            jsonObject.put("type", type.toString());
        } else {
            jsonObject.put("type", null);
        }
        List<String> requiredAttributes = Arrays.asList(def.getRequiredAttributes());
        jsonObject.put("requiredAttributes", requiredAttributes);
        List<String> optionalAttributes = Arrays.asList(def.getOptionalAttributes());
        jsonObject.put("optionalAttributes", optionalAttributes);
        List<String> superClasses = Arrays.asList(def.getSuperiorClasses());
        jsonObject.put("superClasses", superClasses);
        String rawDefinition = def.toString();
        jsonObject.put("rawDefinition", rawDefinition);
        return jsonObject;
    }

    public static Map<String, Object> formatAttributeType(AttributeTypeDefinition def) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        String oid = def.getOID();
        jsonObject.put("OID", oid);
        List<String> names = Arrays.asList(def.getNames());
        jsonObject.put("names", names);
        String description = def.getDescription();
        jsonObject.put("description", description);
        AttributeUsage usage = def.getUsage();
        jsonObject.put("usage", usage.toString());
        boolean obsolete = def.isObsolete();
        jsonObject.put("obsolete", obsolete);
        boolean singleValued = def.isSingleValued();
        jsonObject.put("singleValued", singleValued);
        boolean readOnly = def.isNoUserModification();
        jsonObject.put("readOnly", readOnly);
        boolean collective = def.isCollective();
        jsonObject.put("collective", collective);
        String syntaxOID = def.getSyntaxOID();
        jsonObject.put("syntaxOID", syntaxOID);
        String equalityRule = def.getEqualityMatchingRule();
        jsonObject.put("equalityMatch", equalityRule);
        String orderRule = def.getOrderingMatchingRule();
        jsonObject.put("orderingMatch", orderRule);
        String substringRule = def.getSubstringMatchingRule();
        jsonObject.put("substringMatch", substringRule);
        String superType = def.getSuperiorType();
        jsonObject.put("superType", superType);
        String rawDefinition = def.toString();
        jsonObject.put("rawDefinition", rawDefinition);
        return jsonObject;
    }

    public static Map<String, Object> formatMatchingRule(MatchingRuleDefinition def) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        String oid = def.getOID();
        jsonObject.put("OID", oid);
        List<String> names = Arrays.asList(def.getNames());
        jsonObject.put("names", names);
        String description = def.getDescription();
        jsonObject.put("description", description);
        boolean obsolete = def.isObsolete();
        jsonObject.put("obsolete", obsolete);
        String syntaxOID = def.getSyntaxOID();
        jsonObject.put("syntaxOID", syntaxOID);
        String rawDefinition = def.toString();
        jsonObject.put("rawDefinition", rawDefinition);
        return jsonObject;
    }

    public static Map<String, Object> formatMatchingRuleUse(MatchingRuleUseDefinition def) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        String oid = def.getOID();
        jsonObject.put("OID", oid);
        List<String> names = Arrays.asList(def.getNames());
        jsonObject.put("names", names);
        String description = def.getDescription();
        jsonObject.put("description", description);
        boolean obsolete = def.isObsolete();
        jsonObject.put("obsolete", obsolete);
        List<String> applicableTypes = Arrays.asList(def.getApplicableAttributeTypes());
        jsonObject.put("applicableTypes", applicableTypes);
        String rawDefinition = def.toString();
        jsonObject.put("rawDefinition", rawDefinition);
        return jsonObject;
    }

    public static Map<String, Object> formatSyntax(AttributeSyntaxDefinition def) {
        LinkedHashMap<String, Object> jsonObject = new LinkedHashMap<String, Object>();
        String oid = def.getOID();
        jsonObject.put("OID", oid);
        String description = def.getDescription();
        jsonObject.put("description", description);
        String rawDefinition = def.toString();
        jsonObject.put("rawDefinition", rawDefinition);
        return jsonObject;
    }

    private JSONResultFormatter() {
    }
}

