/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.UnknownHostException;

public class LDAPConnectionException
extends Exception {
    private static final long serialVersionUID = -1421163149598083277L;
    private final CauseType causeType;

    public LDAPConnectionException(String message) {
        this(message, null, null);
    }

    public LDAPConnectionException(String message, CauseType causeType) {
        this(message, causeType, null);
    }

    public LDAPConnectionException(String message, CauseType causeType, Throwable cause) {
        super(message, cause);
        this.causeType = causeType == null ? CauseType.LDAP_CONNECT_ERROR : causeType;
    }

    public static LDAPConnectionException parse(LDAPException e) {
        Throwable cause = e.getCause();
        if (cause == null) {
            return new LDAPConnectionException("General LDAP server connect error", CauseType.LDAP_CONNECT_ERROR);
        }
        if (cause instanceof UnknownHostException) {
            return new LDAPConnectionException("Unknown LDAP server host: " + cause.getMessage(), CauseType.UNKNOWN_HOST, cause);
        }
        if (cause instanceof NoRouteToHostException) {
            return new LDAPConnectionException("No route to LDAP server host: " + cause.getMessage(), CauseType.NO_ROUTE_TO_HOST, cause);
        }
        if (cause instanceof ConnectException) {
            return new LDAPConnectionException("LDAP server down or incorrect port: " + cause.getMessage(), CauseType.LDAP_SERVER_DOWN, cause);
        }
        if (cause instanceof ProtocolException) {
            return new LDAPConnectionException("TCP/IP protocol error: " + cause.getMessage(), CauseType.TCPIP_ERROR, cause);
        }
        if (cause instanceof IOException) {
            String msg = e.getMessage();
            if (msg.contains("java.net.UnknownHostException")) {
                return new LDAPConnectionException("Unknown LDAP server host: " + cause.getMessage(), CauseType.UNKNOWN_HOST, cause);
            }
            if (msg.contains("java.net.NoRouteToHostException")) {
                return new LDAPConnectionException("No route to LDAP server host: " + cause.getMessage(), CauseType.NO_ROUTE_TO_HOST, cause);
            }
            if (msg.contains("java.net.ConnectException")) {
                return new LDAPConnectionException("LDAP server down or incorrect port: " + cause.getMessage(), CauseType.LDAP_SERVER_DOWN, cause);
            }
            if (msg.contains("java.net.ProtocolException")) {
                return new LDAPConnectionException("TCP/IP protocol error: " + cause.getMessage(), CauseType.TCPIP_ERROR, cause);
            }
            if (msg.contains("sun.security.validator.ValidatorException")) {
                return new LDAPConnectionException("Bad server X.509 certificate: " + cause.getMessage(), CauseType.BAD_CERT, cause);
            }
            if (msg.contains("javax.net.ssl")) {
                return new LDAPConnectionException("TLS/SSL error: " + cause.getMessage(), CauseType.TLS_SSL_ERROR, cause);
            }
            if (msg.contains("timeout")) {
                return new LDAPConnectionException("LDAP connect timeout: " + cause.getMessage(), CauseType.CONNECT_TIMEOUT, cause);
            }
            return new LDAPConnectionException("Network I/O error: " + cause.getMessage(), CauseType.NETWORK_IO_ERROR, cause);
        }
        return new LDAPConnectionException("General LDAP server connect error", CauseType.LDAP_CONNECT_ERROR);
    }

    public CauseType getCauseType() {
        return this.causeType;
    }

    public static enum CauseType {
        LDAP_CONNECT_ERROR,
        UNKNOWN_HOST,
        NO_ROUTE_TO_HOST,
        LDAP_SERVER_DOWN,
        TCPIP_ERROR,
        KEYSTORE_ERROR,
        BAD_CERT,
        TLS_SSL_ERROR,
        STARTTLS_ERROR,
        CONNECT_TIMEOUT,
        NETWORK_IO_ERROR;

    }
}

