/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.PickledGraphite;
import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.MonitorConfiguration;
import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.common.servlet.ResourceRetriever;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorLauncher
implements ServletContextListener {
    public static final String CONFIG_CTX_PARAMETER_NAME = "monitor.configurationFile";
    protected JmxReporter jmxReporter;
    protected GraphiteReporter graphiteReporter;

    public void contextInitialized(ServletContextEvent sce) {
        MonitorConfiguration config;
        Properties props;
        sce.getServletContext().setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)MonitorRegistries.getMetricRegistry());
        sce.getServletContext().setAttribute("com.codahale.metrics.servlets.HealthCheckServlet.registry", (Object)MonitorRegistries.getHealthCheckRegistry());
        Logger log = LogManager.getLogger((String)"MAIN");
        try {
            props = ResourceRetriever.getProperties(sce.getServletContext(), CONFIG_CTX_PARAMETER_NAME, log);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            config = new MonitorConfiguration(props);
        }
        catch (ConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (config.enableJMX) {
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)MonitorRegistries.getMetricRegistry()).build();
            this.jmxReporter.start();
            log.info("[CM7100] Started JMX metrics reporter");
        } else {
            log.info("[CM7101] JMX metrics reporting disabled");
        }
        if (config.graphite.enable) {
            Object graphite = config.graphite.batchSize > 0 ? new PickledGraphite(config.graphite.host, config.graphite.port, config.graphite.batchSize) : new Graphite(config.graphite.host, config.graphite.port);
            GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)MonitorRegistries.getMetricRegistry());
            if (config.graphite.prefix != null && !config.graphite.prefix.isEmpty()) {
                builder = builder.prefixedWith(config.graphite.prefix);
            }
            this.graphiteReporter = builder.convertRatesTo(config.graphite.ratesTimeUnit).convertDurationsTo(config.graphite.durationsTimeUnit).filter((MetricFilter)config.graphite.filter).build((GraphiteSender)graphite);
            this.graphiteReporter.start((long)config.graphite.reportInterval, TimeUnit.SECONDS);
            log.info("[CM7102] Started Graphite metrics reporting");
        } else {
            log.info("[CM7103] Graphite metrics reporting disabled");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
        if (this.graphiteReporter != null) {
            this.graphiteReporter.stop();
        }
    }
}

