/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;

public class Banner {
    private String wsName;
    private String wsVersion;
    private String[] handledMethods;
    private String bannerMessage;

    public Banner(String wsName, String wsVersion, String[] methods) {
        if (wsName == null) {
            throw new IllegalArgumentException("The web service name must not be null");
        }
        this.wsName = wsName;
        if (wsVersion == null) {
            throw new IllegalArgumentException("The web service version must not be null");
        }
        this.wsVersion = wsVersion;
        if (methods == null) {
            throw new IllegalArgumentException("The handled JSON-RPC 2.0 method names must not be null");
        }
        this.handledMethods = Arrays.copyOf(methods, methods.length);
        Arrays.sort(this.handledMethods);
        this.bannerMessage = Banner.composeMessage(wsName, wsVersion, this.handledMethods);
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getWsVersion() {
        return this.wsVersion;
    }

    public String[] getHandledJSONRPC2Methods() {
        return this.handledMethods;
    }

    public static String composeMessage(String wsName, String wsVersion, String[] methods) {
        StringBuilder sb = new StringBuilder();
        sb.append("Use HTTP POST to submit your JSON-RPC 2.0 request\n");
        sb.append('\n');
        sb.append("Web service: " + wsName + ", version " + wsVersion + '\n');
        sb.append("Vendor: Connect2id Ltd., http://connect2id.com\n");
        sb.append('\n');
        sb.append("Supported JSON-RPC 2.0 requests:\n");
        for (String m : methods) {
            sb.append("\t* ");
            sb.append(m);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void apply(HttpServletResponse httpResponse) throws IOException {
        httpResponse.setHeader("X-Web-Service", this.wsName);
        httpResponse.setContentType("text/plain;charset=utf-8");
        PrintWriter out = httpResponse.getWriter();
        out.println(this.bannerMessage);
        out.close();
    }
}

