/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;

public class InfinispanLauncher
implements ServletContextListener {
    public static final String INFINISPAN_CONFIG_FILENAME = "infinispan.configurationFile";
    public static final String INFINISPAN_CTX_ATTRIBUTE_NAME = "org.infinispan.manager.EmbeddedCacheManager";
    private EmbeddedCacheManager cacheManager;

    public void contextInitialized(ServletContextEvent sce) {
        Logger log = LogManager.getLogger((String)"MAIN");
        ServletContext servletContext = sce.getServletContext();
        String configFile = servletContext.getInitParameter(INFINISPAN_CONFIG_FILENAME);
        LogManager.getLogger((String)"MAIN").info("[CM8000] Starting Infinispan...");
        if (StringUtils.isBlank((CharSequence)configFile)) {
            String msg = "Couldn't load Infinispan configuration: Missing servlet context parameter \"infinispan.configurationFile\"";
            log.error("[CM8001] " + msg);
            throw new RuntimeException(msg);
        }
        log.info("[CM8002] Infinispan configuration file: {}", new Object[]{configFile});
        InputStream is = servletContext.getResourceAsStream(configFile);
        if (is == null) {
            String msg = "Couldn't load Infinispan configuration file: " + configFile;
            log.error("[CM8003] " + msg);
            throw new RuntimeException(msg);
        }
        try {
            this.cacheManager = new DefaultCacheManager(is);
        }
        catch (Exception e) {
            String msg = "Couldn't start Infinispan cache manager: " + e.getMessage();
            log.error("[CM8004] " + msg);
            throw new RuntimeException(msg, e);
        }
        this.cacheManager.addListener((Object)new StartLogger(new Date()));
        servletContext.setAttribute(INFINISPAN_CTX_ATTRIBUTE_NAME, (Object)this.cacheManager);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Logger log = LogManager.getLogger((String)"MAIN");
        if (this.cacheManager == null) {
            String msg = "[CM8017] Infinispan cache manager not initialised";
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        String msg = "[CM8005] Stopping Infinispan...";
        System.out.println(msg);
        log.info(msg);
        this.cacheManager.addListener((Object)new StopLogger(new Date()));
        this.cacheManager.stop();
    }

    @Listener
    public static class StopLogger {
        private final Date initiationTimestamp;

        public StopLogger(Date initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @CacheStopped
        public void logCacheManagerStop(CacheStoppedEvent event) {
            Date now = new Date();
            long duration = now.getTime() - this.initiationTimestamp.getTime();
            String msg = "[CM8015] Stopped Infinispan cache " + event.getCacheName() + " in " + duration + " ms";
            System.out.println(msg);
            LogManager.getLogger((String)"MAIN").info(msg);
        }
    }

    @Listener
    public static class StartLogger {
        private final Date initiationTimestamp;
        private final AtomicBoolean clusterInfoLogged = new AtomicBoolean(false);

        public StartLogger(Date initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @CacheStarted
        public void logCacheManagerStart(CacheStartedEvent event) {
            Logger log = LogManager.getLogger((String)"MAIN");
            EmbeddedCacheManager cacheManager = event.getCacheManager();
            if (!cacheManager.getCacheManagerConfiguration().isClustered()) {
                log.info("[CM8008] Infinispan clustering: not configured");
            } else if (this.clusterInfoLogged.compareAndSet(false, true)) {
                log.info("[CM8007] Infinispan status: {}", new Object[]{cacheManager.getStatus()});
                log.info("[CM8009] Infinispan cluster name: {}", new Object[]{cacheManager.getCacheManagerConfiguration().transport().clusterName()});
                log.info("[CM8010] Infinispan cluster local node logical address: {}", new Object[]{cacheManager.getAddress()});
                log.info("[CM8019] Infinispan cluster local node physical address(es): {}", new Object[]{cacheManager.getCacheManagerConfiguration().transport().transport().getPhysicalAddresses()});
                log.info("[CM8011] Infinispan cluster coordinator logical address: {}", new Object[]{cacheManager.getCoordinator()});
                log.info("[CM8016] Infinispan cluster local node is coordinator: {}", new Object[]{cacheManager.isCoordinator()});
                log.info("[CM8012] Infinispan cluster members: {}", new Object[]{cacheManager.getMembers()});
                log.info("[CM8013] Infinispan cluster distributed sync timeout: {}", new Object[]{cacheManager.getCacheManagerConfiguration().transport().distributedSyncTimeout()});
                log.info("[CM8014] Infinispan cluster JGroups configuration file: {}", new Object[]{cacheManager.getCacheManagerConfiguration().transport().properties().getProperty("configurationFile")});
            }
            Date now = new Date();
            log.info("[CM8006] Started Infinispan cache {} in {} ms", new Object[]{event.getCacheName(), now.getTime() - this.initiationTimestamp.getTime()});
        }
    }
}

