package com.nimbusds.common.infinispan;


import java.util.List;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.nimbusds.common.monitor.MonitorRegistries;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;


public class InfinispanMetrics {
	
	
	public static void register(final EmbeddedCacheManager cacheManager) {
		
		MetricRegistry metricRegistry = MonitorRegistries.getMetricRegistry();
		
		metricRegistry.register("infinispan.isCoordinator", new Gauge<Boolean>() {
			@Override
			public Boolean getValue() {
				return cacheManager.isCoordinator();
			}
		});
		
		metricRegistry.register("infinispan.numClusterMembers", new Gauge<Integer>() {
			@Override
			public Integer getValue() {
				List<Address> members = cacheManager.getMembers();
				
				if (members == null) {
					return 0; // no cluster
				}
				
				return members.size();
			}
		});
	}
	
	
	/**
	 * Prevents public instantiation.
	 */
	private InfinispanMetrics() {
	}
}
