/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.LoggableConfiguration;
import com.nimbusds.common.monitor.WildCardMetricFilter;
import com.thetransactioncompany.util.PropertyFilter;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.Immutable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public final class MonitorConfiguration
implements LoggableConfiguration {
    public static final String PREFIX = "monitor.";
    public final boolean enableJMX;
    public final Graphite graphite;

    public MonitorConfiguration(Properties props) throws ConfigurationException {
        PropertyRetriever pr = new PropertyRetriever(props, true);
        try {
            this.enableJMX = pr.getOptBoolean("monitor.enableJMX", false);
            this.graphite = new Graphite(props);
        }
        catch (PropertyParseException e) {
            throw new ConfigurationException("Configuration exception: " + e.getMessage() + ": " + e.getPropertyKey() + ": " + e.getPropertyValue());
        }
    }

    @Override
    public void log() {
        Logger log = LogManager.getLogger((String)"MAIN");
        log.info("[CM7000] Overriding system properties: {}", PropertyFilter.filterWithPrefix((String)PREFIX, (Properties)System.getProperties()).stringPropertyNames());
        log.info("[CM7001] JMX reporting enabled: {}", (Object)this.enableJMX);
        this.graphite.log();
    }

    public static final class Graphite
    implements LoggableConfiguration {
        public final boolean enable;
        public final String host;
        public final int port;
        public final int reportInterval;
        public final int batchSize;
        public final String prefix;
        public final TimeUnit ratesTimeUnit;
        public final TimeUnit durationsTimeUnit;
        public final WildCardMetricFilter filter;

        public Graphite(Properties props) throws PropertyParseException {
            PropertyRetriever pr = new PropertyRetriever(props);
            this.enable = pr.getOptBoolean("monitor.graphite.enable", false);
            if (!this.enable) {
                this.host = null;
                this.port = 0;
                this.reportInterval = 0;
                this.batchSize = 0;
                this.prefix = null;
                this.ratesTimeUnit = null;
                this.durationsTimeUnit = null;
                this.filter = null;
                return;
            }
            this.host = pr.getString("monitor.graphite.host");
            this.port = pr.getInt("monitor.graphite.port");
            this.reportInterval = pr.getInt("monitor.graphite.reportInterval");
            this.batchSize = pr.getInt("monitor.graphite.batchSize");
            this.prefix = pr.getOptString("monitor.graphite.prefix", null);
            this.ratesTimeUnit = (TimeUnit)pr.getEnum("monitor.graphite.ratesTimeUnit", TimeUnit.class);
            this.durationsTimeUnit = (TimeUnit)pr.getEnum("monitor.graphite.durationsTimeUnit", TimeUnit.class);
            LinkedList<String> filterWhiteList = new LinkedList<String>();
            for (String key : props.stringPropertyNames()) {
                String filterEntry;
                if (!key.startsWith("monitor.graphite.filter") || (filterEntry = props.getProperty(key)) == null || filterEntry.trim().isEmpty()) continue;
                filterWhiteList.add(filterEntry.trim());
            }
            this.filter = new WildCardMetricFilter(Collections.unmodifiableList(filterWhiteList));
        }

        @Override
        public void log() {
            Logger log = LogManager.getLogger((String)"MAIN");
            log.info("[CM7002] Graphite reporting enabled: {}", (Object)this.enable);
            if (!this.enable) {
                return;
            }
            log.info("[CM7003] Graphite reporting host: {}", (Object)this.host);
            log.info("[CM7004] Graphite reporting port: {}", (Object)this.port);
            log.info("[CM7005] Graphite reporting interval: {}", (Object)this.reportInterval);
            log.info("[CM7006] Graphite reporting batch size: {}", (Object)(this.batchSize + (this.batchSize < 1 ? " disabled" : "")));
            log.info("[CM7007] Graphite reporting prefix: {}", (Object)this.prefix);
            log.info("[CM7008] Graphite reporting rates time unit: {}", (Object)this.ratesTimeUnit);
            log.info("[CM7009] Graphite reporting durations time unit: {}", (Object)this.durationsTimeUnit);
            String filterSetting = this.filter.matchesAny() ? "ANY" : (this.filter.matchesNone() ? "NONE" : this.filter.getWhiteList().toString());
            log.info("[CM7010] Graphite reporting filter: {}", (Object)filterSetting);
        }
    }
}

