/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.infinispan;

import com.codahale.metrics.health.HealthCheck;
import com.nimbusds.common.monitor.MonitorRegistries;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityMode;

public class InfinispanHealthChecks {
    public static void register(final EmbeddedCacheManager cacheManager) {
        cacheManager.getCacheNames().forEach(cacheName -> {
            String healthCheckName = "infinispan." + cacheName + ".availability";
            MonitorRegistries.register(healthCheckName, new HealthCheck((String)cacheName){
                final /* synthetic */ String val$cacheName;
                {
                    this.val$cacheName = string;
                }

                protected HealthCheck.Result check() throws Exception {
                    AvailabilityMode am = cacheManager.getCache(this.val$cacheName).getAdvancedCache().getAvailability();
                    if (AvailabilityMode.DEGRADED_MODE.equals((Object)am)) {
                        return HealthCheck.Result.unhealthy((String)"degraded");
                    }
                    if (AvailabilityMode.AVAILABLE.equals((Object)am)) {
                        return HealthCheck.Result.healthy();
                    }
                    return HealthCheck.Result.unhealthy((String)"unavailable");
                }
            });
        });
    }

    private InfinispanHealthChecks() {
    }
}

