package com.nimbusds.common.id;


import org.apache.commons.lang3.RandomStringUtils;


/**
 * Represents an immutable tenant identifier (TID).
 */
public final class TID extends BaseIdentifier {


	/**
         * Creates a new unique tenant identifier (TID) based on a randomly
	 * generated string of 4 characters.
         */
        public TID() {
        
		this(RandomStringUtils.random(4, true, false).toUpperCase());
        }
	
	
	/**
         * Creates a new tenant identifier (TID) from the specified string.
         *
         * @param value The tenant identifier (TID) value.
         */
        public TID(final String value) {
        
		super(value);
	}
	
	
	/**
         * Overrides {@code Object.equals()}.
         *
         * @param object The object to compare to.
         *
         * @return {@code true} if the objects have the same value, otherwise
         *         {@code false}.
         */
	@Override
        public boolean equals(final Object object) {
        
                return object instanceof TID && this.toString().equalsIgnoreCase(object.toString());
        }
}
