/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.monitor;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WildCardMetricFilter
implements MetricFilter {
    private final List<String> whiteList;
    private final boolean matchNone;
    private final boolean matchAny;

    public WildCardMetricFilter(List<String> whiteList) {
        this.whiteList = whiteList;
        boolean bl = this.matchNone = whiteList == null || whiteList.isEmpty();
        if (whiteList != null) {
            for (String entry : whiteList) {
                if (entry == null || !"*".equals(entry.trim())) continue;
                this.matchAny = true;
                return;
            }
        }
        this.matchAny = false;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public boolean matchesNone() {
        return this.matchNone;
    }

    public boolean matchesAny() {
        return this.matchAny;
    }

    public boolean matches(String name, Metric metric) {
        if (this.matchNone) {
            return false;
        }
        if (this.matchAny) {
            return true;
        }
        if (name == null || name.isEmpty()) {
            return false;
        }
        for (String acceptedName : this.whiteList) {
            if (WildCardMetricFilter.getMatches(name, acceptedName).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static int longestCommonExtension(String t1, int i1, String t2, int i2) {
        int res = 0;
        for (int i = i1; i < t1.length() && i2 < t2.length(); ++i, ++i2) {
            if (t1.charAt(i) == t2.charAt(i2)) {
                ++res;
                continue;
            }
            return res;
        }
        return res;
    }

    public static Collection<String> getMatches(String t, String p) {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (int i = 0; i < t.length(); ++i) {
            int j = 0;
            int h = i;
            int n = p.length();
            while (true) {
                int L;
                if (j + 1 + (L = WildCardMetricFilter.longestCommonExtension(p, j, t, h)) == n + 1) {
                    result.add(t.substring(i, i + n));
                    continue block0;
                }
                if ((j + L >= p.length() || p.charAt(j + L) != '*') && (h + L >= t.length() || t.charAt(h + L) != '*')) continue block0;
                j = j + L + 1;
                h = h + L + 1;
            }
        }
        return result;
    }
}

