/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.common.oauth2.TokenAbbreviator;
import com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.oauth2.sdk.token.Token;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

@ThreadSafe
public class BasicAccessTokenValidator {
    public static final ErrorResponse MISSING_BEARER_TOKEN;
    public static final ErrorResponse INVALID_BEARER_TOKEN;
    public static final ErrorResponse WEB_API_DISABLED;
    private final List<byte[]> expectedTokenHashes = new ArrayList<byte[]>();
    private final byte[] hashSalt = BasicAccessTokenValidator.generate32ByteSalt();
    private Logger log;

    public BasicAccessTokenValidator(BearerAccessToken accessToken) {
        this(new BearerAccessToken[]{accessToken});
    }

    public BasicAccessTokenValidator(BearerAccessToken ... accessTokens) {
        for (BearerAccessToken t : accessTokens) {
            if (t == null) continue;
            this.expectedTokenHashes.add(BasicAccessTokenValidator.computeSHA256(this.hashSalt, t));
        }
    }

    public boolean accessIsDisabled() {
        return this.expectedTokenHashes.isEmpty();
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    private static byte[] generate32ByteSalt() {
        byte[] hashSalt = new byte[32];
        new SecureRandom().nextBytes(hashSalt);
        return hashSalt;
    }

    private static byte[] computeSHA256(byte[] salt, BearerAccessToken token) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            sha256.update(salt);
            return sha256.digest(token.getValue().getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void validateBearerAccessToken(String authzHeader) throws WebApplicationException {
        BearerAccessToken receivedToken;
        if (this.accessIsDisabled()) {
            throw WEB_API_DISABLED.toWebAppException();
        }
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        try {
            receivedToken = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        if (null != this.log) {
            this.log.trace("[CM3000] Validating bearer access token: {}", (Object)TokenAbbreviator.abbreviate((Token)receivedToken));
        }
        byte[] receivedTokenHash = BasicAccessTokenValidator.computeSHA256(this.hashSalt, receivedToken);
        for (byte[] expectedHash : this.expectedTokenHashes) {
            if (!ConstantTimeUtils.areEqual((byte[])receivedTokenHash, (byte[])expectedHash)) continue;
            return;
        }
        throw INVALID_BEARER_TOKEN.toWebAppException();
    }

    public boolean validateBearerAccessToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        BearerAccessToken receivedToken;
        if (this.accessIsDisabled()) {
            WEB_API_DISABLED.apply(servletResponse);
            return false;
        }
        if (servletRequest.getHeader("Authorization") != null) {
            String authzHeaderValue = servletRequest.getHeader("Authorization");
            if (StringUtils.isBlank((CharSequence)authzHeaderValue)) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
            try {
                receivedToken = BearerAccessToken.parse((String)authzHeaderValue);
            }
            catch (ParseException e) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
        } else if (servletRequest.getParameter("access_token") != null) {
            String accessTokenValue = servletRequest.getParameter("access_token");
            if (StringUtils.isBlank((CharSequence)accessTokenValue)) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
            receivedToken = new BearerAccessToken(accessTokenValue);
        } else {
            MISSING_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        if (null != this.log) {
            this.log.trace("[CM3000] Validating bearer access token: {}", (Object)TokenAbbreviator.abbreviate((Token)receivedToken));
        }
        byte[] receivedTokenHash = BasicAccessTokenValidator.computeSHA256(this.hashSalt, receivedToken);
        for (byte[] expectedHash : this.expectedTokenHashes) {
            if (!ConstantTimeUtils.areEqual((byte[])receivedTokenHash, (byte[])expectedHash)) continue;
            return true;
        }
        INVALID_BEARER_TOKEN.apply(servletResponse);
        return false;
    }

    static {
        JSONObject o = new JSONObject();
        o.put((Object)"error", (Object)"missing_token");
        o.put((Object)"error_description", (Object)"Unauthorized: Missing Bearer access token");
        MISSING_BEARER_TOKEN = new ErrorResponse(BearerTokenError.MISSING_TOKEN.getHTTPStatusCode(), BearerTokenError.MISSING_TOKEN.toWWWAuthenticateHeader(), o.toJSONString());
        o = new JSONObject();
        o.put((Object)"error", (Object)BearerTokenError.INVALID_TOKEN.getCode());
        o.put((Object)"error_description", (Object)"Unauthorized: Invalid Bearer access token");
        INVALID_BEARER_TOKEN = new ErrorResponse(BearerTokenError.INVALID_TOKEN.getHTTPStatusCode(), BearerTokenError.INVALID_TOKEN.toWWWAuthenticateHeader(), o.toJSONString());
        o = new JSONObject();
        o.put((Object)"error", (Object)"web_api_disabled");
        o.put((Object)"error_description", (Object)"Forbidden: Web API disabled");
        WEB_API_DISABLED = new ErrorResponse(403, null, o.toJSONString());
    }

    public static class ErrorResponse {
        private final int statusCode;
        private final String wwwAuthHeader;
        private final String body;

        public ErrorResponse(int statusCode, String wwwAuthHeader, String body) {
            this.statusCode = statusCode;
            this.wwwAuthHeader = wwwAuthHeader;
            this.body = body;
        }

        public WebApplicationException toWebAppException() {
            Response.ResponseBuilder builder = Response.status((int)this.statusCode);
            if (this.wwwAuthHeader != null) {
                builder.header("WWW-Authenticate", (Object)this.wwwAuthHeader);
            }
            return new WebApplicationException(builder.entity((Object)this.body).type("application/json").build());
        }

        public void apply(HttpServletResponse servletResponse) throws IOException {
            servletResponse.setStatus(this.statusCode);
            if (this.wwwAuthHeader != null) {
                servletResponse.setHeader("WWW-Authenticate", this.wwwAuthHeader);
            }
            if (this.body != null) {
                servletResponse.setContentType("application/json");
                servletResponse.getWriter().print(this.body);
            }
        }
    }
}

