/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.servlets.AdminServlet;
import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.oauth2.BasicAccessTokenValidator;
import com.nimbusds.common.servlet.ResourceRetriever;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorServlet
extends AdminServlet {
    protected BasicAccessTokenValidator tokenValidator;

    static BasicAccessTokenValidator createBasicAccessTokenValidator(ServletConfig config) throws ServletException {
        Configuration monitorConfig;
        Logger log = LogManager.getLogger((String)"MAIN");
        try {
            Properties props = ResourceRetriever.getProperties(config.getServletContext(), "monitor.configurationFile", log);
            monitorConfig = new Configuration(props);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (monitorConfig.secondaryAPIAccessToken != null) {
            return new BasicAccessTokenValidator(monitorConfig.apiAccessToken, monitorConfig.secondaryAPIAccessToken);
        }
        return new BasicAccessTokenValidator(monitorConfig.apiAccessToken);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tokenValidator = MonitorServlet.createBasicAccessTokenValidator(config);
        LogManager.getLogger((String)"MAIN").info("[CM7110] Loaded monitor API servlet");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.service(req, resp);
    }

    public static class Configuration {
        public static final String API_TOKEN_PROPERTY_NAME = "monitor.apiAccessToken";
        public static final String SECONDARY_API_TOKEN_PROPERTY_NAME = "monitor.secondaryAPIAccessToken";
        public static final int MIN_TOKEN_LENGTH = 32;
        public final BearerAccessToken apiAccessToken;
        public final BearerAccessToken secondaryAPIAccessToken;

        public Configuration(Properties properties) throws ConfigurationException {
            if (System.getProperties().containsKey(API_TOKEN_PROPERTY_NAME)) {
                properties.setProperty(API_TOKEN_PROPERTY_NAME, System.getProperty(API_TOKEN_PROPERTY_NAME));
            }
            if (System.getProperties().containsKey(SECONDARY_API_TOKEN_PROPERTY_NAME)) {
                properties.setProperty(SECONDARY_API_TOKEN_PROPERTY_NAME, System.getProperty(SECONDARY_API_TOKEN_PROPERTY_NAME));
            }
            PropertyRetriever pr = new PropertyRetriever(properties);
            try {
                String s = pr.getString(API_TOKEN_PROPERTY_NAME);
                if (s.trim().length() < 32) {
                    String msg = "The monitor web API access token must be at least 32 characters long";
                    throw new PropertyParseException(msg, API_TOKEN_PROPERTY_NAME, s);
                }
                this.apiAccessToken = new BearerAccessToken(s);
                s = pr.getOptString(SECONDARY_API_TOKEN_PROPERTY_NAME, null);
                if (s != null && s.trim().length() < 32) {
                    String msg = "The secondary monitor web API access token must be at least 32 characters long";
                    throw new PropertyParseException(msg, SECONDARY_API_TOKEN_PROPERTY_NAME, s);
                }
                this.secondaryAPIAccessToken = s != null ? new BearerAccessToken(s) : null;
            }
            catch (PropertyParseException e) {
                throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey(), e);
            }
        }
    }
}

