/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.common.oauth2.MasterAccessTokenValidator;
import com.nimbusds.common.oauth2.TokenAbbreviator;
import com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Token;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;

@ThreadSafe
public class BasicAccessTokenValidator
implements MasterAccessTokenValidator {
    private final List<byte[]> expectedTokenHashes = new ArrayList<byte[]>();
    private final byte[] hashSalt = BasicAccessTokenValidator.generate32ByteSalt();
    private Logger log;

    public BasicAccessTokenValidator(BearerAccessToken accessToken) {
        this(new BearerAccessToken[]{accessToken});
    }

    public BasicAccessTokenValidator(BearerAccessToken ... accessTokens) {
        for (BearerAccessToken t : accessTokens) {
            if (t == null) continue;
            this.expectedTokenHashes.add(MasterAccessTokenValidator.computeSHA256(t, this.hashSalt));
        }
    }

    @Override
    public boolean accessIsDisabled() {
        return this.expectedTokenHashes.isEmpty();
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public void setLogger(Logger log) {
        this.log = log;
    }

    private static byte[] generate32ByteSalt() {
        byte[] hashSalt = new byte[32];
        new SecureRandom().nextBytes(hashSalt);
        return hashSalt;
    }

    @Override
    public void validateBearerAccessToken(String authzHeader) throws WebApplicationException {
        BearerAccessToken receivedToken;
        if (this.accessIsDisabled()) {
            throw WEB_API_DISABLED.toWebAppException();
        }
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        try {
            receivedToken = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        if (null != this.log) {
            this.log.trace("[CM3000] Validating bearer access token: {}", (Object)TokenAbbreviator.abbreviate((Token)receivedToken));
        }
        byte[] receivedTokenHash = MasterAccessTokenValidator.computeSHA256(receivedToken, this.hashSalt);
        for (byte[] expectedHash : this.expectedTokenHashes) {
            if (!ConstantTimeUtils.areEqual((byte[])receivedTokenHash, (byte[])expectedHash)) continue;
            return;
        }
        throw INVALID_BEARER_TOKEN.toWebAppException();
    }

    @Override
    public boolean validateBearerAccessToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        BearerAccessToken receivedToken;
        if (this.accessIsDisabled()) {
            WEB_API_DISABLED.apply(servletResponse);
            return false;
        }
        if (servletRequest.getHeader("Authorization") != null) {
            String authzHeaderValue = servletRequest.getHeader("Authorization");
            if (StringUtils.isBlank((CharSequence)authzHeaderValue)) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
            try {
                receivedToken = BearerAccessToken.parse((String)authzHeaderValue);
            }
            catch (ParseException e) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
        } else if (servletRequest.getParameter("access_token") != null) {
            String accessTokenValue = servletRequest.getParameter("access_token");
            if (StringUtils.isBlank((CharSequence)accessTokenValue)) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
            receivedToken = new BearerAccessToken(accessTokenValue);
        } else {
            MISSING_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        if (null != this.log) {
            this.log.trace("[CM3000] Validating bearer access token: {}", (Object)TokenAbbreviator.abbreviate((Token)receivedToken));
        }
        byte[] receivedTokenHash = MasterAccessTokenValidator.computeSHA256(receivedToken, this.hashSalt);
        for (byte[] expectedHash : this.expectedTokenHashes) {
            if (!ConstantTimeUtils.areEqual((byte[])receivedTokenHash, (byte[])expectedHash)) continue;
            return true;
        }
        INVALID_BEARER_TOKEN.apply(servletResponse);
        return false;
    }
}

