/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.PickledGraphite;
import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.config.MonitorConfiguration;
import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.common.servlet.ResourceRetriever;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorLauncher
implements ServletContextListener {
    public static final String CONFIG_CTX_PARAMETER_NAME = "monitor.configurationFile";
    protected JmxReporter jmxReporter;
    protected GraphiteReporter graphiteReporter;

    public void contextInitialized(ServletContextEvent sce) {
        MonitorConfiguration config;
        Properties props;
        Logger log = LogManager.getLogger((String)"MAIN");
        sce.getServletContext().setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)MonitorRegistries.getMetricRegistry());
        sce.getServletContext().setAttribute("com.codahale.metrics.servlets.HealthCheckServlet.registry", (Object)MonitorRegistries.getHealthCheckRegistry());
        log.info("[CM7106] Started Dropwizard metrics and health checks");
        try {
            props = ResourceRetriever.getProperties(sce.getServletContext(), CONFIG_CTX_PARAMETER_NAME, log);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        props.putAll((Map<?, ?>)System.getProperties());
        try {
            config = new MonitorConfiguration(props);
        }
        catch (ConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        config.log();
        if (config.enableJMX) {
            this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)MonitorRegistries.getMetricRegistry()).build();
            this.jmxReporter.start();
            log.info("[CM7100] Started JMX reporting with {} metrics", (Object)MonitorRegistries.getMetricRegistry().getNames().size());
        } else {
            log.info("[CM7101] JMX metrics reporting disabled");
        }
        if (config.graphite.enable) {
            Object graphite = config.graphite.batchSize > 0 ? new PickledGraphite(config.graphite.host, config.graphite.port, config.graphite.batchSize) : new Graphite(config.graphite.host, config.graphite.port);
            GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)MonitorRegistries.getMetricRegistry());
            if (config.graphite.prefix != null && !config.graphite.prefix.isEmpty()) {
                builder = builder.prefixedWith(config.graphite.prefix);
            }
            this.graphiteReporter = builder.convertRatesTo(config.graphite.ratesTimeUnit).convertDurationsTo(config.graphite.durationsTimeUnit).filter((MetricFilter)config.graphite.filter).build((GraphiteSender)graphite);
            this.graphiteReporter.start((long)config.graphite.reportInterval, TimeUnit.SECONDS);
            List filteredNames = MonitorRegistries.getMetricRegistry().getMetrics().entrySet().stream().filter(entry -> config.graphite.filter.matches((String)entry.getKey(), (Metric)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedList::new));
            if (filteredNames.size() > 0) {
                log.info("[CM7102] Started Graphite reporting with {} metrics: {}", (Object)filteredNames.size(), (Object)filteredNames);
            } else {
                log.warn("[CM7102] Started Graphite reporting, but filter matches zero metrics");
            }
        } else {
            log.info("[CM7103] Graphite metrics reporting disabled");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        String msg;
        Logger log = LogManager.getLogger((String)"MAIN");
        MonitorRegistries.getHealthCheckRegistry().shutdown();
        log.info("[CM7107] Stopped Dropwizard health checks");
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
            msg = "[CM7104] Stopped JMX metrics reporting";
            System.out.println(msg);
            log.info(msg);
        }
        if (this.graphiteReporter != null) {
            this.graphiteReporter.stop();
            msg = "[CM7105] Stopped Graphite metrics reporting";
            System.out.println(msg);
            log.info(msg);
        }
    }
}

