/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.config;

import com.nimbusds.common.config.WebServiceDetails;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Json2LdapDetails
extends WebServiceDetails {
    public final boolean useDefaultLDAPServer;
    public static final boolean DEFAULT_LDAP_SERVER = true;

    public Json2LdapDetails(String prefix, Properties props) throws PropertyParseException {
        super(prefix, props);
        PropertyRetriever pr = new PropertyRetriever(props);
        this.useDefaultLDAPServer = pr.getOptBoolean(prefix + "useDefaultLDAPServer", true);
    }

    @Override
    public void log() {
        Logger log = LogManager.getLogger((String)"MAIN");
        log.info("[CM2300] Json2Ldap URL: {}", (Object)this.url);
        if (this.url.getProtocol().equalsIgnoreCase("http")) {
            log.warn("[CM2301] Json2Ldap connection is not protected (plain HTTP), consider using SSL (HTTPS)");
        }
        log.info("[CM2302] Json2Ldap with default LDAP server: {}", (Object)this.useDefaultLDAPServer);
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            log.info("[CM2303] Self-signed Json2Ldap certificates are trusted: {}", (Object)this.trustSelfSignedCerts);
        }
        if (this.connectTimeout > 0) {
            log.info("[CM2304] Json2Ldap HTTP connect timeout: {} ms", (Object)this.connectTimeout);
        } else {
            log.info("[CM2304] Json2Ldap HTTP connect timeout: disabled");
        }
        if (this.readTimeout > 0) {
            log.info("[CM2305] Json2Ldap HTTP read timeout: {} ms", (Object)this.readTimeout);
        } else {
            log.info("[CM2305] Json2Ldap HTTP read timeout: disabled");
        }
        if (this.apiKey != null) {
            log.info("[CM2306] Json2Ldap API key: provided");
        } else {
            log.info("[CM2306] Json2Ldap API key: not provided");
        }
    }
}

