/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.minidev.json.JSONObject;
import org.apache.logging.log4j.Logger;

public interface MasterAccessTokenValidator {
    public static final ErrorResponse MISSING_BEARER_TOKEN = new ErrorResponse(BearerTokenError.MISSING_TOKEN.getHTTPStatusCode(), BearerTokenError.MISSING_TOKEN.toWWWAuthenticateHeader(), "missing_token", "Unauthorized: Missing Bearer access token");
    public static final ErrorResponse INVALID_BEARER_TOKEN = new ErrorResponse(BearerTokenError.INVALID_TOKEN.getHTTPStatusCode(), BearerTokenError.INVALID_TOKEN.toWWWAuthenticateHeader(), BearerTokenError.INVALID_TOKEN.getCode(), "Unauthorized: Invalid Bearer access token");
    public static final ErrorResponse WEB_API_DISABLED = new ErrorResponse(403, null, "web_api_disabled", "Forbidden: Web API disabled");

    public static byte[] computeSHA256(BearerAccessToken token, byte[] salt) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            if (salt != null) {
                sha256.update(salt);
            }
            return sha256.digest(token.getValue().getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean accessIsDisabled();

    public Logger getLogger();

    public void setLogger(Logger var1);

    public void validateBearerAccessToken(String var1) throws WebApplicationException;

    public boolean validateBearerAccessToken(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    public static class ErrorResponse {
        private final int statusCode;
        private final String wwwAuthHeader;
        private final String body;

        public ErrorResponse(int statusCode, String wwwAuthHeader, String bodyErrorCode, String bodyErrorDesc) {
            this.statusCode = statusCode;
            this.wwwAuthHeader = wwwAuthHeader;
            JSONObject bodyErrorObj = new JSONObject();
            bodyErrorObj.put((Object)"error", (Object)bodyErrorCode);
            bodyErrorObj.put((Object)"error_description", (Object)bodyErrorDesc);
            this.body = bodyErrorObj.toJSONString();
        }

        public WebApplicationException toWebAppException() {
            Response.ResponseBuilder builder = Response.status((int)this.statusCode);
            if (this.wwwAuthHeader != null) {
                builder.header("WWW-Authenticate", (Object)this.wwwAuthHeader);
            }
            return new WebApplicationException(builder.entity((Object)this.body).type("application/json").build());
        }

        public void apply(HttpServletResponse servletResponse) throws IOException {
            servletResponse.setStatus(this.statusCode);
            if (this.wwwAuthHeader != null) {
                servletResponse.setHeader("WWW-Authenticate", this.wwwAuthHeader);
            }
            if (this.body != null) {
                servletResponse.setContentType("application/json");
                servletResponse.getWriter().print(this.body);
            }
        }
    }
}

