/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

class LDAPControlResultFormatter {
    LDAPControlResultFormatter() {
    }

    public static void appendSearchControlResults(Map<String, Object> jsonObject, SearchResult searchResult) {
        for (Control c : searchResult.getResponseControls()) {
            if (c instanceof SimplePagedResultsControl) {
                SimplePagedResultsControl prc = (SimplePagedResultsControl)c;
                LinkedHashMap<String, Object> page = new LinkedHashMap<String, Object>();
                page.put("totalEntryCount", prc.getSize());
                page.put("more", prc.moreResultsToReturn());
                if (prc.getCookie() != null) {
                    page.put("cookie", Base64.encode((byte[])prc.getCookie().getValue()));
                } else {
                    page.put("cookie", "");
                }
                jsonObject.put("page", page);
            }
            if (!(c instanceof VirtualListViewResponseControl)) continue;
            VirtualListViewResponseControl vrc = (VirtualListViewResponseControl)c;
            LinkedHashMap<String, Object> vlv = new LinkedHashMap<String, Object>();
            vlv.put("totalEntryCount", vrc.getContentCount());
            vlv.put("offset", vrc.getTargetPosition());
            if (vrc.getContextID() != null) {
                vlv.put("cookie", Base64.encode((byte[])vrc.getContextID().getValue()));
            } else {
                vlv.put("cookie", null);
            }
            jsonObject.put("vlv", vlv);
        }
    }
}

