package com.nimbusds.common.spi;


import java.util.Iterator;
import java.util.ServiceLoader;


/**
 * Service loader utility.
 */
public class ServiceLoaderUtility {
	
	
	/**
	 * Loads a single Service Provider Interface (SPI) implementation, if
	 * not found returns the specified default one.
	 *
	 * @param tClass      The SPI. Not {@code null}.
	 * @param defaultImpl The default implementation, {@code null} if not
	 *                    specified.
	 *
	 * @return The loaded SPI implementation or the default one.
	 *
	 * @throws RuntimeException If more than one SPI implementation was
	 *                          found.
	 */
	public static <T> T loadSingle(final Class<T> tClass, final T defaultImpl) {
		
		T impl = null;
		
		Iterator<T> it = ServiceLoader.load(tClass).iterator();
		
		if (it.hasNext()) {
			
			impl = it.next();
			
			if (it.hasNext())
				throw new RuntimeException("More than one " + tClass.getName() + " SPI implementation found");
		}
		
		if (impl == null) impl = defaultImpl;
		
		return impl;
	}
}
