/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.servlets.AdminServlet;
import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.oauth2.MasterAccessTokenValidator;
import com.nimbusds.common.oauth2.SHA256BasedAccessTokenValidator;
import com.nimbusds.common.servlet.ResourceRetriever;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorServlet
extends AdminServlet {
    protected MasterAccessTokenValidator tokenValidator;

    static MasterAccessTokenValidator createAccessTokenValidator(ServletConfig config) throws ServletException {
        Configuration monitorConfig;
        Logger log = LogManager.getLogger((String)"MAIN");
        try {
            Properties props = ResourceRetriever.getProperties(config.getServletContext(), "monitor.configurationFile", log);
            monitorConfig = new Configuration(props);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (monitorConfig.secondaryAPIAccessTokenSHA256 != null) {
            return new SHA256BasedAccessTokenValidator(monitorConfig.apiAccessTokenSHA256, monitorConfig.secondaryAPIAccessTokenSHA256);
        }
        return new SHA256BasedAccessTokenValidator(monitorConfig.apiAccessTokenSHA256);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tokenValidator = MonitorServlet.createAccessTokenValidator(config);
        LogManager.getLogger((String)"MAIN").info("[CM7110] Loaded monitor API servlet");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.service(req, resp);
    }

    public static class Configuration {
        public static final String API_TOKEN_SHA256_PROPERTY_NAME = "monitor.apiAccessTokenSHA256";
        public static final String SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME = "monitor.secondaryAPIAccessTokenSHA256";
        public final String apiAccessTokenSHA256;
        public final String secondaryAPIAccessTokenSHA256;

        public Configuration(Properties properties) throws ConfigurationException {
            if (System.getProperties().containsKey(API_TOKEN_SHA256_PROPERTY_NAME)) {
                properties.setProperty(API_TOKEN_SHA256_PROPERTY_NAME, System.getProperty(API_TOKEN_SHA256_PROPERTY_NAME));
            }
            if (System.getProperties().containsKey(SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME)) {
                properties.setProperty(SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME, System.getProperty(SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME));
            }
            PropertyRetriever pr = new PropertyRetriever(properties);
            try {
                this.apiAccessTokenSHA256 = pr.getOptString(API_TOKEN_SHA256_PROPERTY_NAME, null);
                this.secondaryAPIAccessTokenSHA256 = pr.getOptString(SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME, null);
            }
            catch (PropertyParseException e) {
                throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey(), e);
            }
        }
    }
}

