package com.nimbusds.common.infinispan;


import org.infinispan.Cache;


/**
 * Detects if a cache's mode is synchronous or asynchronous invalidation.
 */
@Deprecated
public class InvalidationCacheModeDetector {
	
	
	/**
	 * Checks if the specified caches are configured in invalidation mode.
	 *
	 * @param caches The caches to check.
	 *
	 * @return {@code true} if the at least one of the caches is configured
	 *         in invalidation mode, else {@code false}.
	 */
	public static boolean detect(final Cache ... caches) {
		
		for (Cache cache: caches) {
			
			if (CacheWorkArounds.detectInvalidationMode(cache)) {
				return true;
			}
		}
		
		return false;
	}
	
	
	/**
	 * Prevents public instantiation.
	 */
	private InvalidationCacheModeDetector() {}
}
