/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.id;

import com.nimbusds.common.id.Identifier;
import java.security.SecureRandom;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import org.apache.commons.codec.binary.Base64;

public abstract class BaseIdentifier
implements Identifier,
Comparable<Identifier>,
JSONAware {
    protected static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private final String value;

    public BaseIdentifier() {
        this(32);
    }

    public BaseIdentifier(int byteLength) {
        byte[] n = new byte[byteLength];
        SECURE_RANDOM.nextBytes(n);
        this.value = Base64.encodeBase64URLSafeString((byte[])n);
    }

    public BaseIdentifier(String value) {
        if (value == null) {
            throw new IllegalArgumentException("The value must not be null");
        }
        this.value = value;
    }

    @Override
    public int compareTo(Identifier other) {
        return this.value.compareTo(other.toString());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.value;
    }

    public String toJSONString() {
        return '\"' + JSONObject.escape((String)this.value) + '\"';
    }
}

