/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.infinispan;

import java.util.HashMap;
import java.util.HashSet;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.redis.configuration.RedisServerConfiguration;
import org.infinispan.persistence.redis.configuration.RedisStoreConfiguration;

public class RedisCacheStoreChecks {
    public static void check(EmbeddedCacheManager cacheManager) throws ConfigWarning, ConfigError {
        HashMap hostToDbIndexMappings = new HashMap();
        for (String cacheName : cacheManager.getCacheNames()) {
            Cache cache = cacheManager.getCache(cacheName);
            for (StoreConfiguration storeConfig : cache.getCacheConfiguration().persistence().stores()) {
                if (!(storeConfig instanceof RedisStoreConfiguration)) continue;
                RedisStoreConfiguration redisStoreConfig = (RedisStoreConfiguration)storeConfig;
                if (redisStoreConfig.database() == 0) {
                    throw new ConfigWarning("The Redis Cache store for " + cacheName + " must specify a non-zero database number to prevent potential conflicts with meta keys such as ElastiCacheMasterReplicationTimestamp that may get put into the default (0) database");
                }
                for (RedisServerConfiguration redisServerConfig : redisStoreConfig.servers()) {
                    String host = redisServerConfig.host() + ":" + redisServerConfig.port();
                    HashSet<Integer> dbNums = (HashSet<Integer>)hostToDbIndexMappings.get(host);
                    if (dbNums == null) {
                        dbNums = new HashSet<Integer>();
                    }
                    hostToDbIndexMappings.put(host, dbNums);
                    if (dbNums.contains(redisStoreConfig.database())) {
                        throw new ConfigError("The Redis Cache store " + host + " for " + cacheName + " uses a database number " + redisStoreConfig.database() + " that is already taken");
                    }
                    dbNums.add(redisStoreConfig.database());
                }
            }
        }
    }

    private RedisCacheStoreChecks() {
    }

    public static class ConfigError
    extends RuntimeException {
        public ConfigError(String message) {
            super(message);
        }
    }

    public static class ConfigWarning
    extends Exception {
        public ConfigWarning(String message) {
            super(message);
        }
    }
}

