/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.common.oauth2.MasterAccessTokenValidator;
import com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

abstract class AbstractAccessTokenValidator
implements MasterAccessTokenValidator {
    protected final List<byte[]> expectedTokenHashes = new ArrayList<byte[]>();
    protected byte[] hashSalt = null;
    protected Logger log;

    AbstractAccessTokenValidator() {
    }

    @Override
    public boolean accessIsDisabled() {
        return this.expectedTokenHashes.isEmpty();
    }

    @Override
    public boolean isValid(BearerAccessToken accessToken) {
        if (accessToken == null) {
            return false;
        }
        byte[] receivedTokenHash = MasterAccessTokenValidator.computeSHA256(accessToken, this.hashSalt);
        for (byte[] expectedHash : this.expectedTokenHashes) {
            if (!ConstantTimeUtils.areEqual((byte[])receivedTokenHash, (byte[])expectedHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public void setLogger(Logger log) {
        this.log = log;
    }
}

