package com.nimbusds.common.infinispan;


import org.infinispan.Cache;


/**
 * Detects if a cache is configured in "zero mode", meaning the cache mode is
 * local and entries must be fetched directly from the underlying store(s).
 * Infinispan doesn't permit setting a cache size to zero, therefore one (1) is
 * used to imply a "zero mode".
 *
 * <p>The "zero mode" is intended to facilitate deployments where Redis or
 * some other database is intended to serve as in-memory cache / map.
 */
@Deprecated
public class ZeroCacheModeDetector {
	
	
	/**
	 * Checks if the specified caches are configured in "zero mode".
	 *
	 * @param caches The caches to check.
	 *
	 * @return {@code true} if the at least one of the caches is configured
	 *         in "zero mode", else {@code false}.
	 */
	public static boolean detect(final Cache ... caches) {
		
		for (Cache cache: caches) {
			
			if (CacheWorkArounds.detectStatelessMode(cache)) {
				return true;
			}
		}
		
		return false;
	}
	
	
	/**
	 * Prevents public instantiation.
	 */
	private ZeroCacheModeDetector() {}
}
