/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.nimbusds.common.http.ForwardedParser;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServletLogUtility {
    private static final Logger LOG = LogManager.getLogger((String)"MAIN");

    public static String composeLogMessage(HttpServletRequest httpRequest) {
        X509Certificate[] certs;
        String corsOrigin = String.valueOf(httpRequest.getAttribute("cors.origin"));
        StringBuilder msg = new StringBuilder("HTTP");
        if (httpRequest.isSecure()) {
            msg.append("S");
        }
        if (!corsOrigin.equals("null")) {
            msg.append(" CORS");
        }
        msg.append(' ');
        msg.append(httpRequest.getMethod());
        msg.append(" request: ip=");
        String clientIP = ForwardedParser.getClientIPAddressFromForwardedHeader(httpRequest.getHeader("Forwarded"));
        if (clientIP == null && (clientIP = ForwardedParser.getClientIPAddressFromXForwardedForHeader(httpRequest.getHeader("X-Forwarded-For"))) == null) {
            clientIP = httpRequest.getRemoteAddr();
        }
        msg.append(clientIP);
        if (!corsOrigin.equals("null")) {
            msg.append(" origin=");
            msg.append(corsOrigin);
        }
        if ((certs = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate")) != null) {
            for (int i = 0; i < certs.length; ++i) {
                X500Principal principal = certs[i].getSubjectX500Principal();
                if (principal == null) continue;
                String principalName = principal.getName();
                msg.append(" principal[" + i + "]=" + principalName);
            }
        }
        msg.append(" path=");
        msg.append(httpRequest.getRequestURI());
        return msg.toString();
    }

    public static void log(HttpServletRequest httpRequest) {
        ServletLogUtility.log(LOG, httpRequest);
    }

    public static void log(Logger log, HttpServletRequest httpRequest) {
        if (log == null || httpRequest == null) {
            return;
        }
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info(ServletLogUtility.composeLogMessage(httpRequest));
    }

    private ServletLogUtility() {
    }
}

