/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.servlets.AdminServlet;
import com.nimbusds.common.oauth2.BasicAccessTokenValidator;
import com.nimbusds.common.servlet.ResourceRetriever;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorServlet
extends AdminServlet {
    public static final String API_TOKEN_PROPERTY_NAME = "monitor.apiAccessToken";
    public static final int MIN_TOKEN_LENGTH = 32;
    protected BasicAccessTokenValidator tokenValidator;

    static BasicAccessTokenValidator createBasicAccessTokenValidator(ServletConfig config) throws ServletException {
        String tokenString;
        Properties props;
        Logger log = LogManager.getLogger((String)"MAIN");
        try {
            props = ResourceRetriever.getProperties(config.getServletContext(), "monitor.configurationFile", log);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (System.getProperties().containsKey(API_TOKEN_PROPERTY_NAME)) {
            props.setProperty(API_TOKEN_PROPERTY_NAME, System.getProperty(API_TOKEN_PROPERTY_NAME));
        }
        PropertyRetriever pr = new PropertyRetriever(props);
        try {
            tokenString = pr.getString(API_TOKEN_PROPERTY_NAME);
        }
        catch (PropertyParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        if (tokenString.length() < 32) {
            String msg = "The monitor web API access token must be at least 32 characters long";
            log.error(msg);
            throw new ServletException(msg);
        }
        return new BasicAccessTokenValidator(new BearerAccessToken(tokenString));
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tokenValidator = MonitorServlet.createBasicAccessTokenValidator(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.service(req, resp);
    }
}

