/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.spi;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.Set;

public class ServiceLoaderUtility {
    public static <T> T loadSingle(Class<T> tClass, T defaultImpl) {
        LinkedList<T> impls = new LinkedList<T>();
        for (T t : ServiceLoader.load(tClass)) {
            impls.add(t);
        }
        if (impls.isEmpty()) {
            return defaultImpl;
        }
        if (impls.size() > 1) {
            LinkedList<String> classNames = new LinkedList<String>();
            for (Object impl : impls) {
                classNames.add(impl.getClass().getName());
            }
            throw new RuntimeException("More than one " + tClass.getName() + " SPI implementation found: " + classNames);
        }
        return (T)impls.get(0);
    }

    public static <T> Set<T> loadMultiple(Class<T> tClass, T defaultImpl) {
        HashSet<T> impls = new HashSet<T>();
        for (T t : ServiceLoader.load(tClass)) {
            impls.add(t);
        }
        if (impls.isEmpty() && defaultImpl != null) {
            impls.add(defaultImpl);
        }
        return impls;
    }
}

