/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.oauth2;

import com.nimbusds.common.oauth2.AbstractAccessTokenValidator;
import com.nimbusds.common.oauth2.TokenAbbreviator;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public class SHA256BasedAccessTokenValidator
extends AbstractAccessTokenValidator {
    public static final int MIN_TOKEN_LENGTH = 32;

    public SHA256BasedAccessTokenValidator(String tokenHash) {
        this(new String[]{tokenHash});
    }

    public SHA256BasedAccessTokenValidator(String ... tokenHashes) {
        for (String hash : tokenHashes) {
            if (hash == null) continue;
            try {
                this.expectedTokenHashes.add(Hex.decodeHex((char[])hash.toCharArray()));
            }
            catch (DecoderException e) {
                throw new IllegalArgumentException("Invalid hex: " + hash);
            }
        }
        this.hashSalt = null;
    }

    public SHA256BasedAccessTokenValidator(String tokenHash, List<String> additionalTokenHashes) {
        if (tokenHash == null) {
            return;
        }
        try {
            this.expectedTokenHashes.add(Hex.decodeHex((char[])tokenHash.toCharArray()));
            if (additionalTokenHashes != null) {
                for (String hash : additionalTokenHashes) {
                    if (hash == null) continue;
                    this.expectedTokenHashes.add(Hex.decodeHex((char[])hash.toCharArray()));
                }
            }
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Invalid hex");
        }
    }

    public static SHA256BasedAccessTokenValidator from(PropertyRetriever pr, String propertyName, boolean propertyRequired, String additionalPropertyNamePrefix) throws PropertyParseException {
        String tokenHash = propertyRequired ? pr.getString(propertyName) : pr.getOptString(propertyName, null);
        if (additionalPropertyNamePrefix == null) {
            return new SHA256BasedAccessTokenValidator(tokenHash);
        }
        List additionalTokenHashes = pr.getOptStringListMulti(additionalPropertyNamePrefix, Collections.emptyList());
        return new SHA256BasedAccessTokenValidator(tokenHash, additionalTokenHashes);
    }

    @Override
    public void validateBearerAccessToken(String authzHeader) throws WebApplicationException {
        BearerAccessToken receivedToken;
        if (this.accessIsDisabled()) {
            throw WEB_API_DISABLED.toWebAppException();
        }
        if (StringUtils.isBlank((CharSequence)authzHeader)) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        try {
            receivedToken = BearerAccessToken.parse((String)authzHeader);
        }
        catch (ParseException e) {
            throw MISSING_BEARER_TOKEN.toWebAppException();
        }
        if (null != this.log) {
            this.log.trace("[CM3000] Validating bearer access token: {}", (Object)TokenAbbreviator.abbreviate((Token)receivedToken));
        }
        if (receivedToken.getValue().length() < 32) {
            throw INVALID_BEARER_TOKEN.toWebAppException();
        }
        if (this.isValid(receivedToken)) {
            return;
        }
        throw INVALID_BEARER_TOKEN.toWebAppException();
    }

    @Override
    public boolean validateBearerAccessToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        BearerAccessToken receivedToken;
        if (this.accessIsDisabled()) {
            WEB_API_DISABLED.apply(servletResponse);
            return false;
        }
        if (servletRequest.getHeader("Authorization") != null) {
            String authzHeaderValue = servletRequest.getHeader("Authorization");
            if (StringUtils.isBlank((CharSequence)authzHeaderValue)) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
            try {
                receivedToken = BearerAccessToken.parse((String)authzHeaderValue);
            }
            catch (ParseException e) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
        } else if (servletRequest.getParameter("access_token") != null) {
            String accessTokenValue = servletRequest.getParameter("access_token");
            if (StringUtils.isBlank((CharSequence)accessTokenValue)) {
                MISSING_BEARER_TOKEN.apply(servletResponse);
                return false;
            }
            receivedToken = new BearerAccessToken(accessTokenValue);
        } else {
            MISSING_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        if (null != this.log) {
            this.log.trace("[CM3000] Validating bearer access token: {}", (Object)TokenAbbreviator.abbreviate((Token)receivedToken));
        }
        if (receivedToken.getValue().length() < 32) {
            INVALID_BEARER_TOKEN.apply(servletResponse);
            return false;
        }
        if (this.isValid(receivedToken)) {
            return true;
        }
        INVALID_BEARER_TOKEN.apply(servletResponse);
        return false;
    }
}

