package com.nimbusds.common.json;


import net.minidev.json.JSONValue;


/**
 * JSON serialisation.
 */
public final class JSON {
	
	
	/**
	 * Serialises the specified object to a JSON string. Unicode characters
	 * are not escaped.
	 *
	 * @param obj The object.
	 *
	 * @return The JSON string.
	 */
	public static String toJSON(final Object obj) {
		
		if (obj == null) {
			return "null";
		}
		
		return JSONValue.toJSONString(obj);
	}
}
