package com.nimbusds.common.json;


import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Config;


/**
 * JSON serialisation.
 */
public final class JSON {
	
	
	private static final Config CONFIG = new Config.Builder().escapeUnicode(false).build();
	
	
	/**
	 * Serialises the specified object to a JSON string. Unicode characters
	 * are not escaped.
	 *
	 * @param obj The object.
	 *
	 * @return The JSON string.
	 */
	public static String toJSON(final Object obj) {
		
		if (obj == null) {
			return "null";
		}
		
		return JsonStream.serialize(CONFIG, obj);
	}
}
