/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.log;

import com.nimbusds.oauth2.sdk.id.Identifier;
import org.apache.commons.lang3.StringUtils;

public class LogSanitizer {
    private static String escapeMetaCharacters(String inputString) {
        String[] metaCharacters;
        for (String metaCharacter : metaCharacters = new String[]{"\\", "{", "}", "[", "]", "(", ")", "|", "&", "%"}) {
            if (!inputString.contains(metaCharacter)) continue;
            inputString = inputString.replace(metaCharacter, "\\" + metaCharacter);
        }
        inputString = inputString.replace("\n", "\\n");
        inputString = inputString.replace("\r", "\\r");
        inputString = inputString.replace("\t", "\\t");
        return inputString;
    }

    public static String sanitize(Identifier identifier) {
        return LogSanitizer.sanitize(identifier, 20);
    }

    public static String sanitize(Identifier identifier, int maxLength) {
        return identifier != null ? LogSanitizer.sanitize(identifier.getValue(), maxLength) : null;
    }

    public static String sanitize(String string, int maxLength) {
        if (string == null) {
            return null;
        }
        String trimmed = StringUtils.abbreviate((String)string, (String)"...", (int)maxLength);
        return LogSanitizer.escapeMetaCharacters(trimmed);
    }
}

