/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.nimbusds.common.monitor.MonitorRegistries;
import com.nimbusds.common.oauth2.MasterAccessTokenValidator;
import com.nimbusds.common.servlet.MonitorServlet;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;

public class PrometheusMonitorServlet
extends MetricsServlet {
    protected MasterAccessTokenValidator tokenValidator;

    static CollectorRegistry getConfiguredCollectorRegistry() {
        CollectorRegistry r = new CollectorRegistry();
        r.register((Collector)new DropwizardExports(MonitorRegistries.getMetricRegistry()));
        return r;
    }

    public PrometheusMonitorServlet() {
        super(PrometheusMonitorServlet.getConfiguredCollectorRegistry());
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tokenValidator = MonitorServlet.createAccessTokenValidator(config);
        LogManager.getLogger((String)"MAIN").info("[CM7111] Loaded Prometheus monitor API servlet");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.service(req, resp);
    }
}

