/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import com.codahale.metrics.servlets.AdminServlet;
import com.nimbusds.common.config.ConfigurationException;
import com.nimbusds.common.oauth2.MasterAccessTokenValidator;
import com.nimbusds.common.oauth2.SHA256BasedAccessTokenValidator;
import com.nimbusds.common.servlet.ResourceRetriever;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonitorServlet
extends AdminServlet {
    protected MasterAccessTokenValidator tokenValidator;

    static MasterAccessTokenValidator createAccessTokenValidator(ServletConfig config) throws ServletException {
        Logger log = LogManager.getLogger((String)"MAIN");
        try {
            Properties props = ResourceRetriever.getProperties(config.getServletContext(), "monitor.configurationFile", log);
            return new Configuration((Properties)props).apiAccessTokenSHA256;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tokenValidator = MonitorServlet.createAccessTokenValidator(config);
        LogManager.getLogger((String)"MAIN").info("[CM7110] Loaded monitor API servlet");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.doGet(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.tokenValidator.validateBearerAccessToken(req, resp)) {
            return;
        }
        super.service(req, resp);
    }

    public static class Configuration {
        public static final String API_TOKEN_SHA256_PROPERTY_NAME = "monitor.apiAccessTokenSHA256";
        public static final String SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME = "monitor.secondaryAPIAccessTokenSHA256";
        public final SHA256BasedAccessTokenValidator apiAccessTokenSHA256;

        public Configuration(Properties properties) throws ConfigurationException {
            String secondaryTokenHash = properties.getProperty(SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME);
            if (secondaryTokenHash != null && !secondaryTokenHash.trim().isEmpty()) {
                properties.setProperty("monitor.apiAccessTokenSHA256.xxx", secondaryTokenHash);
            }
            if ((secondaryTokenHash = System.getProperties().getProperty(SECONDARY_API_TOKEN_SHA256_PROPERTY_NAME)) != null && !secondaryTokenHash.trim().isEmpty()) {
                properties.setProperty("monitor.apiAccessTokenSHA256.xxx", secondaryTokenHash);
            }
            PropertyRetriever pr = new PropertyRetriever(properties, true);
            try {
                this.apiAccessTokenSHA256 = SHA256BasedAccessTokenValidator.from(pr, API_TOKEN_SHA256_PROPERTY_NAME, false, "monitor.apiAccessTokenSHA256.");
            }
            catch (PropertyParseException e) {
                throw new ConfigurationException(e.getMessage() + ": Property: " + e.getPropertyKey(), e);
            }
        }
    }
}

