/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.nimbusds.common.jsonrpc2.Banner;
import com.nimbusds.common.jsonrpc2.JSONRPC2LogUtility;
import com.nimbusds.common.jsonrpc2.RequestHandlerWithLifecycle;
import com.nimbusds.common.servlet.ServletLogUtility;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.server.MessageContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Function;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JSONRPC2Servlet
extends HttpServlet {
    protected RequestHandlerWithLifecycle service;
    protected String wsName;
    protected String wsVersion;
    protected Banner banner;
    protected String responseContentType;
    protected Function<Integer, Integer> httpStatusCodeMapper;
    private final Logger log = LogManager.getLogger(JSONRPC2Servlet.class);

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
        JSONRPC2Request request;
        PrintWriter out;
        ServletLogUtility.log(httpRequest);
        MessageContext requestContext = new MessageContext(httpRequest);
        httpResponse.setHeader("X-Web-Service", this.wsName);
        httpResponse.setContentType(this.responseContentType);
        try {
            out = httpResponse.getWriter();
        }
        catch (IOException e) {
            this.log.error("HTTP POST I/O exception: {}", (Object)e.getMessage(), (Object)e);
            throw new ServletException("HTTP POST I/O exception: " + e.getMessage(), (Throwable)e);
        }
        StringBuilder postContent = new StringBuilder(256);
        try {
            String line;
            BufferedReader reader = httpRequest.getReader();
            while ((line = reader.readLine()) != null) {
                postContent.append(line);
                postContent.append(System.getProperty("line.separator"));
            }
            reader.close();
        }
        catch (IOException e) {
            this.log.error("HTTP POST I/O exception: {}", (Object)e.getMessage(), (Object)e);
            throw new ServletException("HTTP POST I/O exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            request = JSONRPC2Request.parse((String)postContent.toString());
        }
        catch (JSONRPC2ParseException e) {
            this.log.info("Invalid JSON-RPC 2.0 request: {}", (Object)e.getMessage());
            out.println(new JSONRPC2Response(JSONRPC2Error.PARSE_ERROR, null));
            return;
        }
        JSONRPC2Response response = this.service.process(request, requestContext);
        if (this.httpStatusCodeMapper != null && !response.indicatesSuccess()) {
            JSONRPC2Error jsonrpc2Error = response.getError();
            httpResponse.setStatus(this.httpStatusCodeMapper.apply(jsonrpc2Error.getCode()).intValue());
        }
        out.println(response);
        out.close();
        JSONRPC2LogUtility.log(request, response);
    }

    public void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
        ServletLogUtility.log(httpRequest);
        httpResponse.setHeader("X-Web-Service", this.wsName);
        httpResponse.setContentType("text/plain; charset=utf-8");
        try {
            this.banner.apply(httpResponse);
        }
        catch (IOException e) {
            this.log.error("HTTP GET I/O exception: {}", (Object)e.getMessage(), (Object)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        this.log.info("Stopping {} ...", (Object)this.wsName);
        try {
            this.service.stop();
        }
        catch (Exception e) {
            this.log.warn("{} stop exception: ", (Object)this.wsName, (Object)e.getMessage(), (Object)e);
        }
    }
}

