/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;

public class LDAPExceptionUtils {
    public static JSONRPC2Error toJSONRPC2Error(LDAPException ldapException) {
        ResultCode ldapCode = ldapException.getResultCode();
        int code = ldapCode.intValue();
        Object message = ldapCode.getName();
        message = message != null && ((String)message).length() > 1 ? "LDAP error: " + ((String)message).substring(0, 1).toUpperCase() + ((String)message).substring(1) : "LDAP error";
        return new JSONRPC2Error(code, (String)message);
    }

    public static void ensureSuccess(LDAPResult result) throws JSONRPC2Error {
        ResultCode ldapCode = result.getResultCode();
        if (ldapCode == ResultCode.SUCCESS) {
            return;
        }
        int code = ldapCode.intValue();
        Object message = result.getDiagnosticMessage();
        if (message == null) {
            message = ldapCode.getName();
        }
        message = message != null && ((String)message).length() > 1 ? "LDAP error: " + ((String)message).substring(0, 1).toUpperCase() + ((String)message).substring(1) : "LDAP error";
        throw new JSONRPC2Error(code, (String)message);
    }

    private LDAPExceptionUtils() {
    }
}

