/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.config.ServerSelectionAlgorithm;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import javax.net.SocketFactory;

public class LDAPServerSetFactory {
    public static ServerSet create(LDAPURL[] url, ServerSelectionAlgorithm selectionAlgorithm, SocketFactory socketFactory, LDAPConnectionOptions opts) {
        if (url.length == 0) {
            throw new IllegalArgumentException("At least one server must be specified in the LDAP URL array");
        }
        if (url.length == 1) {
            return new SingleServerSet(url[0].getHost(), url[0].getPort(), socketFactory, opts);
        }
        String[] hosts = new String[url.length];
        int[] ports = new int[url.length];
        for (int i = 0; i < url.length; ++i) {
            hosts[i] = url[i].getHost();
            ports[i] = url[i].getPort();
        }
        if (selectionAlgorithm == ServerSelectionAlgorithm.FAILOVER) {
            return new FailoverServerSet(hosts, ports, socketFactory, opts);
        }
        if (selectionAlgorithm == ServerSelectionAlgorithm.ROUND_ROBIN) {
            return new RoundRobinServerSet(hosts, ports, socketFactory, opts);
        }
        throw new IllegalArgumentException("Unexpected LDAP server selection algorithm: " + selectionAlgorithm);
    }

    private LDAPServerSetFactory() {
    }
}

