/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.ldap;

import com.nimbusds.common.servlet.ResourceRetriever;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SampleDirectory
implements ServletContextListener {
    private InMemoryDirectoryServer ds = null;
    private ServletContext servletContext;
    private final Logger log = LogManager.getLogger((String)"MAIN");

    public void start(Configuration config) throws LDAPException, IOException, LDIFException {
        if (!config.enable) {
            this.log.info("Sample directory server: disabled");
            return;
        }
        InMemoryListenerConfig listenerConfig = InMemoryListenerConfig.createLDAPConfig((String)"sample-ds", (int)config.port);
        Schema schema = null;
        if (config.schema != null) {
            InputStream ldifInput = this.servletContext != null ? this.servletContext.getResourceAsStream(config.schema) : new FileInputStream(config.schema);
            if (ldifInput == null) {
                throw new IOException("Couldn't find schema LDIF file: " + config.schema);
            }
            LDIFReader ldifReader = new LDIFReader(ldifInput);
            schema = new Schema(ldifReader.readEntry());
            this.log.info("Sample directory server: Schema LDIF file: {}", (Object)config.schema);
        }
        InMemoryDirectoryServerConfig dsConfig = new InMemoryDirectoryServerConfig(new String[]{config.baseDN});
        this.log.info("Sample directory server: Base DN: {}", (Object)config.baseDN);
        dsConfig.setSchema(schema);
        dsConfig.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
        dsConfig.setAllowedOperationTypes(config.operations);
        this.ds = new InMemoryDirectoryServer(dsConfig);
        if (config.content != null) {
            InputStream ldifInput = this.servletContext != null ? this.servletContext.getResourceAsStream(config.content) : new FileInputStream(config.content);
            if (ldifInput == null) {
                throw new IOException("Couldn't find directory content LDIF file: " + config.content);
            }
            this.ds.importFromLDIF(true, new LDIFReader(ldifInput));
            ldifInput.close();
            this.log.info("Sample directory server: Populated from LDIF file {}", (Object)config.content);
        }
        this.ds.startListening();
        this.log.info("Sample directory server: Started on port {}", (Object)this.ds.getListenPort());
    }

    public void stop() {
        if (this.ds == null) {
            return;
        }
        this.ds.shutDown(true);
        this.log.info("Sample directory server: Shut down");
    }

    public void contextInitialized(ServletContextEvent sce) {
        Configuration config;
        this.servletContext = sce.getServletContext();
        try {
            Properties props = ResourceRetriever.getProperties(this.servletContext, "sampleDirectory.configurationFile", this.log);
            config = new Configuration(props);
        }
        catch (Exception e) {
            this.log.error("Couldn't configure sample directory server: {}", (Object)e.getMessage());
            return;
        }
        try {
            this.start(config);
        }
        catch (LDAPException e) {
            this.log.error("Couldn't start sample directory server: {}", (Object)e.getMessage());
        }
        catch (LDIFException | IOException e) {
            this.log.error("Couldn't read schema file: {}", (Object)e.getMessage());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.stop();
    }

    public static class Configuration {
        public final boolean enable;
        public static final boolean DEFAULT_ENABLE = false;
        public final int port;
        public static final int DEFAULT_PORT = 10389;
        public final Set<OperationType> operations;
        public static final Set<OperationType> DEFAULT_OPERATIONS = new HashSet<OperationType>(Arrays.asList(OperationType.BIND, OperationType.COMPARE, OperationType.SEARCH, OperationType.EXTENDED));
        public final String schema;
        public final String baseDN;
        public final String content;

        public Configuration(Properties props) throws PropertyParseException {
            PropertyRetriever pr = new PropertyRetriever(props, true);
            this.enable = pr.getOptBoolean("sampleDirectoryServer.enable", false);
            if (!this.enable) {
                this.port = 10389;
                this.operations = DEFAULT_OPERATIONS;
                this.schema = null;
                this.baseDN = null;
                this.content = null;
                return;
            }
            this.port = pr.getOptInt("sampleDirectoryServer.port", 10389);
            String s = pr.getOptString("sampleDirectoryServer.operations", null);
            if (s != null && !s.trim().isEmpty()) {
                String[] tokens = s.split("[\\s,]+");
                HashSet<OperationType> ops = new HashSet<OperationType>();
                for (String t : tokens) {
                    try {
                        ops.add(OperationType.valueOf((String)t.toUpperCase()));
                    }
                    catch (Exception e) {
                        throw new PropertyParseException("Invalid LDAP operation: " + t, "sampleDirectoryServer.operations", s);
                    }
                }
                this.operations = Collections.unmodifiableSet(ops);
            } else {
                this.operations = DEFAULT_OPERATIONS;
            }
            s = pr.getOptString("sampleDirectoryServer.schema", null);
            this.schema = s == null || s.isEmpty() ? null : s;
            this.baseDN = pr.getString("sampleDirectoryServer.baseDN");
            s = pr.getOptString("sampleDirectoryServer.content", null);
            this.content = s == null || s.isEmpty() ? null : s;
        }
    }
}

