/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.infinispan;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;

public class CacheWorkArounds<K, V> {
    private final Cache<K, V> infinispanCache;
    private final Mode mode;

    public static boolean detectInvalidationMode(Cache<?, ?> cache) {
        return List.of(CacheMode.INVALIDATION_SYNC, CacheMode.INVALIDATION_ASYNC).contains(cache.getCacheConfiguration().clustering().cacheMode());
    }

    public static boolean detectStatelessMode(Cache<?, ?> cache) {
        boolean isLocal = CacheMode.LOCAL.equals((Object)cache.getCacheConfiguration().clustering().cacheMode());
        boolean isSizeOne = 1L == cache.getCacheConfiguration().memory().size() || 1L == cache.getCacheConfiguration().memory().maxCount();
        return isLocal && isSizeOne;
    }

    public CacheWorkArounds(Cache<K, V> infinispanCache) {
        this(infinispanCache, null);
    }

    public CacheWorkArounds(Cache<K, V> infinispanCache, Logger log) {
        this.infinispanCache = infinispanCache;
        this.mode = CacheWorkArounds.detectInvalidationMode(infinispanCache) ? Mode.INVALIDATION : (CacheWorkArounds.detectStatelessMode(infinispanCache) ? Mode.STATELESS : null);
        if (log != null && this.mode != null) {
            log.info("[CM8020] Detected Infinispan cache {} in {} mode", (Object)infinispanCache.getName(), (Object)this.mode);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isInvalidation() {
        return Mode.INVALIDATION.equals((Object)this.getMode());
    }

    public boolean isStateless() {
        return Mode.STATELESS.equals((Object)this.getMode());
    }

    public void clearCacheIfStateless() {
        if (!this.isStateless()) {
            return;
        }
        this.infinispanCache.getAdvancedCache().getDataContainer().clear();
    }

    public static enum Mode {
        INVALIDATION,
        STATELESS;

    }
}

