/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.nimbusds.common.jsonrpc2.WsInfo;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2Session;
import com.thetransactioncompany.jsonrpc2.client.JSONRPC2SessionException;
import java.net.URL;

public class WsDetector {
    private final JSONRPC2Session session;

    public WsDetector(URL url) {
        this.session = new JSONRPC2Session(url);
    }

    public JSONRPC2Session getSession() {
        return this.session;
    }

    public WsInfo detect() throws Exception {
        JSONRPC2Response response;
        try {
            response = this.session.send(new JSONRPC2Request("ws.getName", (Object)0));
        }
        catch (JSONRPC2SessionException e) {
            throw new Exception(e.getMessage(), e);
        }
        if (!response.indicatesSuccess()) {
            JSONRPC2Error err = response.getError();
            throw new Exception("ws.getName failed: [" + err.getCode() + "] " + err.getMessage(), err);
        }
        if (!(response.getResult() instanceof String)) {
            throw new Exception("Unexpected ws.getName response, must be a string");
        }
        String wsName = (String)response.getResult();
        try {
            response = this.session.send(new JSONRPC2Request("ws.getVersion", (Object)0));
        }
        catch (JSONRPC2SessionException e) {
            throw new Exception(e.getMessage(), e);
        }
        if (!response.indicatesSuccess()) {
            JSONRPC2Error err = response.getError();
            throw new Exception("ws.getVersion failed: [" + err.getCode() + "] " + err.getMessage(), err);
        }
        Object object = response.getResult();
        if (!(object instanceof String)) {
            throw new Exception("Unexpected ws.getVersion response, must be a string");
        }
        String wsVersion = (String)object;
        return new WsInfo(wsName, wsVersion);
    }
}

