/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.jsonrpc2;

import com.nimbusds.common.jsonrpc2.WsInfo;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.server.MessageContext;
import com.thetransactioncompany.jsonrpc2.server.RequestHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class WsInfoRequestHandler
implements RequestHandler {
    private static final SimpleDateFormat iso8601DateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private WsInfo wsInfo;
    private static final String[] HANDLED_REQUESTS = new String[]{"ws.getName", "ws.getVersion", "ws.getTime"};

    public void init(WsInfo wsInfo) {
        if (wsInfo == null) {
            throw new IllegalArgumentException("The web service info must not be null");
        }
        this.wsInfo = wsInfo;
        iso8601DateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public String[] handledRequests() {
        return HANDLED_REQUESTS;
    }

    private String getWsTime() {
        Date now = new Date();
        return iso8601DateTimeFormat.format(now) + "Z";
    }

    public JSONRPC2Response process(JSONRPC2Request request, MessageContext requestCtx) {
        String result;
        String method = request.getMethod();
        Object id = request.getID();
        try {
            result = switch (method) {
                case "ws.getName" -> this.wsInfo.getName();
                case "ws.getVersion" -> this.wsInfo.getVersion();
                case "ws.getTime" -> this.getWsTime();
                default -> throw JSONRPC2Error.METHOD_NOT_FOUND;
            };
        }
        catch (JSONRPC2Error e) {
            return new JSONRPC2Response(e, id);
        }
        return new JSONRPC2Response((Object)result, id);
    }
}

