/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.common.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public class ResourceRetriever {
    private static String getInitParam(ServletContext servletCtx, String paramName, Logger logger) throws Exception {
        String param = servletCtx.getInitParameter(paramName);
        if (param == null || param.trim().isEmpty()) {
            String msg = "Missing servlet context (web.xml) init parameter: " + paramName;
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg);
        }
        return param;
    }

    private static String getInitParam(ServletConfig servletConfig, String paramName, Logger logger) throws Exception {
        String param = servletConfig.getInitParameter(paramName);
        if (param == null || param.trim().isEmpty()) {
            String msg = "Missing servlet (web.xml) init parameter: " + paramName;
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg);
        }
        return param;
    }

    public static InputStream getStream(ServletContext servletCtx, String paramName, Logger logger) throws Exception {
        String file = ResourceRetriever.getInitParam(servletCtx, paramName, logger);
        InputStream is = servletCtx.getResourceAsStream(file);
        if (is == null) {
            String msg = "Missing file or invalid path: " + file;
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg);
        }
        return is;
    }

    public static InputStream getOptStream(ServletContext servletCtx, String paramName, Logger logger) throws Exception {
        String file = ResourceRetriever.getInitParam(servletCtx, paramName, logger);
        return servletCtx.getResourceAsStream(file);
    }

    public static InputStream getStream(ServletConfig servletConfig, String paramName, Logger logger) throws Exception {
        String file = ResourceRetriever.getInitParam(servletConfig, paramName, logger);
        InputStream is = servletConfig.getServletContext().getResourceAsStream(file);
        if (is == null) {
            String msg = "Missing file or invalid path: " + file;
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg);
        }
        return is;
    }

    public static String getString(ServletContext servletCtx, String paramName, Logger logger) throws Exception {
        InputStream is = ResourceRetriever.getStream(servletCtx, paramName, logger);
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
            }
            reader.close();
        }
        catch (IOException e) {
            String msg = "Couldn't read file: " + e.getMessage();
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg, e);
        }
        return sb.toString();
    }

    public static Properties getProperties(ServletContext servletCtx, String paramName, Logger logger) throws Exception {
        return ResourceRetriever.getProperties(servletCtx, paramName, false, logger);
    }

    public static Properties getProperties(ServletContext servletCtx, String paramName, boolean ignoreMissingFile, Logger logger) throws Exception {
        String file = servletCtx.getInitParameter(paramName);
        InputStream is = ResourceRetriever.getOptStream(servletCtx, paramName, logger);
        Properties props = new Properties();
        if (is == null && ignoreMissingFile) {
            return props;
        }
        try {
            props.load(is);
        }
        catch (IOException e) {
            String msg = "Couldn't read properties file: " + e.getMessage();
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad properties file: " + e.getMessage();
            if (logger != null) {
                logger.error(msg);
            }
            throw new Exception(msg, e);
        }
        if (logger != null) {
            logger.info("Loaded properties file {}", (Object)file);
        }
        return props;
    }

    public static Properties getProperties(ServletConfig servletConfig, String paramName, Logger logger) throws Exception {
        return ResourceRetriever.getProperties(servletConfig.getServletContext(), paramName, logger);
    }

    private ResourceRetriever() {
    }
}

