/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.RSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSAEncrypter
extends RSAProvider
implements JWEEncrypter {
    private final SecureRandom randomGen;
    private final RSAPublicKey pubKey;

    public RSAEncrypter(RSAPublicKey pubKey) {
        this.pubKey = pubKey;
        try {
            this.randomGen = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("Java Security provider doesn't support SHA1PRNG");
        }
    }

    public JWECryptoParts encrypt(ReadOnlyJWEHeader readOnlyJWEHeader, byte[] bytes) throws JOSEException {
        JWEAlgorithm algorithm = readOnlyJWEHeader.getAlgorithm();
        EncryptionMethod method = readOnlyJWEHeader.getEncryptionMethod();
        Base64URL encryptedKey = null;
        Base64URL cipherText = null;
        try {
            int keyLength = this.keyLengthForMethod(method);
            SecretKey contentEncryptionKey = RSAEncrypter.generateAESCMK(keyLength);
            if (algorithm.equals(JWEAlgorithm.RSA1_5)) {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(1, this.pubKey);
                encryptedKey = Base64URL.encode(cipher.doFinal(contentEncryptionKey.getEncoded()));
            } else if (algorithm.equals(JWEAlgorithm.RSA_OAEP)) {
                try {
                    RSAEngine engine = new RSAEngine();
                    OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)engine);
                    BigInteger mod = this.pubKey.getModulus();
                    BigInteger exp = this.pubKey.getPublicExponent();
                    RSAKeyParameters keyParams = new RSAKeyParameters(false, mod, exp);
                    cipher.init(true, (CipherParameters)keyParams);
                    int inputBlockSize = cipher.getInputBlockSize();
                    int outputBlockSize = cipher.getOutputBlockSize();
                    byte[] keyBytes = contentEncryptionKey.getEncoded();
                    encryptedKey = Base64URL.encode(cipher.processBlock(keyBytes, 0, keyBytes.length));
                }
                catch (InvalidCipherTextException e) {
                    throw new JOSEException(e.getMessage(), e);
                }
            } else {
                throw new JOSEException("Algorithm must be RSA1_5 or RSA_OAEP");
            }
            if (encryptedKey == null) {
                throw new JOSEException("Couldn't generate encrypted key");
            }
            if (method.equals(EncryptionMethod.A128GCM) || method.equals(EncryptionMethod.A256GCM)) {
                byte[] iv = this.generateAESGCMIV();
                IvParameterSpec ivParamSpec = new IvParameterSpec(iv);
                cipherText = Base64URL.encode(this.aesgcmEncrypt(ivParamSpec, contentEncryptionKey, bytes));
                JWECryptoParts parts = new JWECryptoParts(encryptedKey, Base64URL.encode(iv), cipherText, null);
                return parts;
            }
            throw new JOSEException("Unsupported encryption method");
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid Key Exception", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Java Security Provider doesn't support the algorithm specified", e);
        }
        catch (BadPaddingException e) {
            throw new JOSEException("Bad padding exception", e);
        }
        catch (NoSuchPaddingException e) {
            throw new JOSEException("No such padding Exception", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new JOSEException("Illegal Block Size exception", e);
        }
    }

    protected static SecretKey generateAESCMK(int keyLength) throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance("AES");
        keygen.init(keyLength);
        return keygen.generateKey();
    }

    protected byte[] generateAESGCMIV() {
        byte[] bytes = new byte[12];
        this.randomGen.nextBytes(bytes);
        return bytes;
    }
}

