/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.RSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSADecrypter
extends RSAProvider
implements JWEDecrypter {
    private final String symmetricAlgorithm = "AES";
    public static final JWEHeaderFilter HEADER_FILTER = new JWEHeaderFilter(){

        @Override
        public Set<JWEAlgorithm> getAcceptedAlgorithms() {
            return RSAProvider.SUPPORTED_ALGORITHMS;
        }

        @Override
        public void setAcceptedAlgorithms(Set<JWEAlgorithm> jweAlgorithms) {
        }

        @Override
        public Set<EncryptionMethod> getAcceptedEncryptionMethods() {
            return RSAProvider.SUPPORTED_ENCRYPTION_METHODS;
        }

        @Override
        public void setAcceptedEncryptionMethods(Set<EncryptionMethod> encryptionMethods) {
        }

        @Override
        public Set<String> getAcceptedParameters() {
            HashSet<String> parameters = new HashSet<String>();
            parameters.add("alg");
            parameters.add("enc");
            parameters.add("zip");
            parameters.add("typ");
            return parameters;
        }

        @Override
        public void setAcceptedParameters(Set<String> parameters) {
        }
    };
    private RSAPrivateKey privateKey;

    public JWEHeaderFilter getJWEHeaderFilter() {
        return HEADER_FILTER;
    }

    public RSADecrypter(RSAPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] decrypt(ReadOnlyJWEHeader readOnlyJWEHeader, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL integrityValue) throws JOSEException {
        if (encryptedKey == null) {
            throw new JOSEException("Missing encrypted key");
        }
        if (iv == null) {
            throw new JOSEException("Missing initialization vector");
        }
        if (integrityValue == null) {
            throw new JOSEException("Missing integrity value");
        }
        JWEAlgorithm algorithm = readOnlyJWEHeader.getAlgorithm();
        EncryptionMethod method = readOnlyJWEHeader.getEncryptionMethod();
        int keyLength = this.keyLengthForMethod(method);
        SecretKeySpec keySpec = this.getKeySpec(algorithm, method, encryptedKey.decode(), this.privateKey);
        String authDataString = readOnlyJWEHeader.toBase64URL().toString() + "." + encryptedKey.toString() + "." + iv.toString();
        byte[] authData = null;
        try {
            authData = authDataString.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return AESGCM.decrypt(keySpec, cipherText.decode(), authData, integrityValue.decode(), iv.decode());
    }

    private SecretKeySpec getKeySpec(JWEAlgorithm alg, EncryptionMethod method, byte[] cipherText, PrivateKey inputKey) throws JOSEException {
        int keyLength = this.keyLengthForMethod(method);
        try {
            if (alg.equals(JWEAlgorithm.RSA_OAEP)) {
                RSAPrivateKey key = (RSAPrivateKey)inputKey;
                RSAEngine engine = new RSAEngine();
                OAEPEncoding cipher = new OAEPEncoding((AsymmetricBlockCipher)engine);
                BigInteger mod = key.getModulus();
                BigInteger exp = key.getPrivateExponent();
                RSAKeyParameters keyParams = new RSAKeyParameters(true, mod, exp);
                cipher.init(false, (CipherParameters)keyParams);
                byte[] secretKeyBytes = cipher.processBlock(cipherText, 0, cipherText.length);
                return new SecretKeySpec(secretKeyBytes, "AES");
            }
            if (alg.equals(JWEAlgorithm.RSA1_5)) {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(2, this.privateKey);
                byte[] secretKeyBytes = cipher.doFinal(cipherText);
                if (8 * secretKeyBytes.length != keyLength) {
                    throw new Exception("WebToken.decrypt RSA PKCS1Padding symmetric key length mismatch: " + secretKeyBytes.length + " != " + keyLength);
                }
                return new SecretKeySpec(secretKeyBytes, "AES");
            }
            throw new JOSEException("Unsupported JWEAlgorithm");
        }
        catch (InvalidCipherTextException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        catch (NoSuchPaddingException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }
}

