/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEAlgorithmProvider;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RSAProvider
implements JWEAlgorithmProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;

    RSAProvider() {
    }

    @Override
    public Set<JWEAlgorithm> supportedAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public Set<EncryptionMethod> supportedEncryptionMethods() {
        return SUPPORTED_ENCRYPTION_METHODS;
    }

    protected int keyLengthForMethod(EncryptionMethod method) {
        if (method.equals(EncryptionMethod.A128CBC_HS256) || method.equals(EncryptionMethod.A128GCM)) {
            return 128;
        }
        if (method.equals(EncryptionMethod.A256GCM) || method.equals(EncryptionMethod.A256CBC_HS512)) {
            return 256;
        }
        throw new IllegalArgumentException("Unsupported encryption method, must be A128GCM, A256GCM, A128CBC_HS256 or A256CBC_HS512");
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.RSA_OAEP);
        algs.add(JWEAlgorithm.RSA1_5);
        SUPPORTED_ALGORITHMS = algs;
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A256GCM);
        methods.add(EncryptionMethod.A128GCM);
        SUPPORTED_ENCRYPTION_METHODS = methods;
    }
}

