/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class OctetSequenceKey
extends JWK {
    private final Base64URL k;

    public OctetSequenceKey(Base64URL k, Use use, Algorithm alg, String kid) {
        super(KeyType.OCT, use, alg, kid);
        if (k == null) {
            throw new IllegalArgumentException("The key value must not be null");
        }
        this.k = k;
    }

    public Base64URL getKeyValue() {
        return this.k;
    }

    public byte[] toByteArray() {
        return this.getKeyValue().decode();
    }

    public boolean isPrivate() {
        return true;
    }

    public OctetSequenceKey toPublicJWK() {
        return null;
    }

    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"k", (Object)this.k.toString());
        return o;
    }

    public static OctetSequenceKey parse(String s) throws ParseException {
        return OctetSequenceKey.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static OctetSequenceKey parse(JSONObject jsonObject) throws ParseException {
        Base64URL k = new Base64URL(JSONObjectUtils.getString(jsonObject, "k"));
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty != KeyType.OCT) {
            throw new ParseException("The key type \"kty\" must be oct", 0);
        }
        Use use = JWK.parseKeyUse(jsonObject);
        Algorithm alg = JWK.parseAlgorithm(jsonObject);
        String kid = JWK.parseKeyID(jsonObject);
        return new OctetSequenceKey(k, use, alg, kid);
    }
}

