/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class RSA1_5 {
    public static byte[] encryptCMK(RSAPublicKey publicKey, SecretKey contentMasterKey) throws JOSEException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, publicKey);
            return cipher.doFinal(contentMasterKey.getEncoded());
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    public static SecretKey decryptCMK(RSAPrivateKey privateKey, byte[] encryptedCMK, int keyLength) throws JOSEException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            byte[] secretKeyBytes = cipher.doFinal(encryptedCMK);
            if (8 * secretKeyBytes.length != keyLength) {
                throw new JOSEException("CMK key length mismatch: " + secretKeyBytes.length + " != " + keyLength);
            }
            return new SecretKeySpec(secretKeyBytes, "AES");
        }
        catch (Exception e) {
            throw new JOSEException(e.getMessage(), e);
        }
    }

    private RSA1_5() {
    }
}

