/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.DefaultJWEHeaderFilter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEHeaderFilter;
import com.nimbusds.jose.ReadOnlyJWEHeader;
import com.nimbusds.jose.crypto.AESCBC;
import com.nimbusds.jose.crypto.AESGCM;
import com.nimbusds.jose.crypto.ConcatKDF;
import com.nimbusds.jose.crypto.DeflateHelper;
import com.nimbusds.jose.crypto.DirectCryptoProvider;
import com.nimbusds.jose.crypto.HMAC;
import com.nimbusds.jose.util.Base64URL;
import java.io.UnsupportedEncodingException;
import javax.crypto.SecretKey;
import org.bouncycastle.util.Arrays;

public class DirectDecrypter
extends DirectCryptoProvider
implements JWEDecrypter {
    private final DefaultJWEHeaderFilter headerFilter = new DefaultJWEHeaderFilter(this.supportedAlgorithms(), this.supportedEncryptionMethods());

    public DirectDecrypter(byte[] key) throws JOSEException {
        super(key);
    }

    public JWEHeaderFilter getJWEHeaderFilter() {
        return this.headerFilter;
    }

    public byte[] decrypt(ReadOnlyJWEHeader readOnlyJWEHeader, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL integrityValue) throws JOSEException {
        byte[] plainText;
        if (encryptedKey != null) {
            throw new JOSEException("Unexpected encrypted key, must be omitted");
        }
        if (iv == null) {
            throw new JOSEException("The initialization vector (IV) must not be null");
        }
        if (integrityValue == null) {
            throw new JOSEException("The integrity value must not be null");
        }
        JWEAlgorithm alg = readOnlyJWEHeader.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException("Unsupported algorithm, must be \"dir\"");
        }
        EncryptionMethod enc = readOnlyJWEHeader.getEncryptionMethod();
        if (enc.equals(EncryptionMethod.A128CBC_HS256) || enc.equals(EncryptionMethod.A256CBC_HS512)) {
            byte[] epu = null;
            if (readOnlyJWEHeader.getEncryptionPartyUInfo() != null) {
                epu = readOnlyJWEHeader.getEncryptionPartyUInfo().decode();
            }
            byte[] epv = null;
            if (readOnlyJWEHeader.getEncryptionPartyVInfo() != null) {
                epv = readOnlyJWEHeader.getEncryptionPartyVInfo().decode();
            }
            SecretKey cek = ConcatKDF.generateCEK(this.cmk, enc, epu, epv);
            plainText = AESCBC.decrypt(cek, iv.decode(), cipherText.decode());
            SecretKey cik = ConcatKDF.generateCIK(this.cmk, enc, epu, epv);
            String macInput = readOnlyJWEHeader.toBase64URL().toString() + "." + "." + iv.toString() + "." + cipherText.toString();
            byte[] mac = HMAC.compute(cik, macInput.getBytes());
            if (!Arrays.constantTimeAreEqual((byte[])integrityValue.decode(), (byte[])mac)) {
                throw new JOSEException("HMAC integrity check failed");
            }
        } else if (enc.equals(EncryptionMethod.A128GCM) || enc.equals(EncryptionMethod.A256GCM)) {
            String authDataString = readOnlyJWEHeader.toBase64URL().toString() + "." + "." + iv.toString();
            byte[] authData = null;
            try {
                authData = authDataString.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JOSEException(e.getMessage(), e);
            }
            plainText = AESGCM.decrypt(this.cmk, iv.decode(), cipherText.decode(), authData, integrityValue.decode());
        } else {
            throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256, A256CBC_HS512, A128GCM or A128GCM");
        }
        return DeflateHelper.applyDecompression(readOnlyJWEHeader, plainText);
    }
}

