/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.BaseJWEProvider;
import java.util.HashSet;
import java.util.Set;

abstract class RSACryptoProvider
extends BaseJWEProvider {
    public static final Set<JWEAlgorithm> SUPPORTED_ALGORITHMS;
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;

    protected static int cekBitLength(EncryptionMethod method) throws JOSEException {
        int len = method.cmkBitLength();
        if (len < 1) {
            throw new JOSEException("Unsupported encryption method");
        }
        return len;
    }

    protected static int cikBitLength(EncryptionMethod method) throws JOSEException {
        if (method.equals(EncryptionMethod.A128CBC_HS256)) {
            return 256;
        }
        if (method.equals(EncryptionMethod.A256CBC_HS512)) {
            return 512;
        }
        throw new JOSEException("Unsupported encryption method, must be A128CBC_HS256 or A256CBC_HS512");
    }

    protected RSACryptoProvider() {
        super(SUPPORTED_ALGORITHMS, SUPPORTED_ENCRYPTION_METHODS);
    }

    static {
        HashSet<JWEAlgorithm> algs = new HashSet<JWEAlgorithm>();
        algs.add(JWEAlgorithm.RSA1_5);
        algs.add(JWEAlgorithm.RSA_OAEP);
        SUPPORTED_ALGORITHMS = algs;
        HashSet<EncryptionMethod> methods = new HashSet<EncryptionMethod>();
        methods.add(EncryptionMethod.A128CBC_HS256);
        methods.add(EncryptionMethod.A256CBC_HS512);
        methods.add(EncryptionMethod.A128GCM);
        methods.add(EncryptionMethod.A256GCM);
        SUPPORTED_ENCRYPTION_METHODS = methods;
    }
}

